
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "envelope.h"


LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
ENVELOPE_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	ENVELOPE * i = new ENVELOPE;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum ENVELOPE_port_enum {
	ENVELOPE_out_enum, ENVELOPE_ifn_enum, ENVELOPE_idur_enum, ENVELOPE_ksection_enum, ENVELOPE_kamp_enum, ENVELOPE_args_enum, ENVELOPE_2_enum, 
};

void
ENVELOPE_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	ENVELOPE * ins = (ENVELOPE *)Instance;
	switch(Port) {

		case ENVELOPE_out_enum:
			ins->out = DataLocation;
			break;

		case ENVELOPE_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case ENVELOPE_idur_enum:
			ins->idur = DataLocation;
			break;

		case ENVELOPE_ksection_enum:
			ins->ksection = DataLocation;
			break;

		case ENVELOPE_kamp_enum:
			ins->kamp = DataLocation;
			break;

		case ENVELOPE_args_enum:
			ins->args = DataLocation;
			break;

		case ENVELOPE_2_enum:
			ins->2 = DataLocation;
			break;

		default:
			break;
	}
}

enum descriptor_enum {
	
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;

	if (!inited) {

		inited=true;
	}
	
	switch(Index) {

		default:
			return 0;
	}
}
