
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "dam.h"


LADSPA_Handle
DAM_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DAM * i = new DAM;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DAM_port_enum {
	DAM_aout_enum, DAM_ain_enum, DAM_kthreshold_enum, DAM_icomp1_enum, DAM_icomp2_enum, DAM_rtime_enum, DAM_ftime_enum, 
};

void
DAM_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DAM * ins = (DAM *)Instance;
	switch(Port) {

		case DAM_aout_enum:
			ins->aout = DataLocation;
			break;

		case DAM_ain_enum:
			ins->ain = DataLocation;
			break;

		case DAM_kthreshold_enum:
			ins->kthreshold = DataLocation;
			break;

		case DAM_icomp1_enum:
			ins->icomp1 = DataLocation;
			break;

		case DAM_icomp2_enum:
			ins->icomp2 = DataLocation;
			break;

		case DAM_rtime_enum:
			ins->rtime = DataLocation;
			break;

		case DAM_ftime_enum:
			ins->ftime = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
dam_activate(LADSPA_Handle Instance)
{
	DAM * ins = (DAM *)Instance;
	daminit(ins);
}

void
dam_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DAM * ins = (DAM *)Instance;
	set_qcs_controlrate(SampleCount);
	dam(ins);
}

void
dam_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_dam_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "dam";
	d->Name = "dam";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="aout";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="ain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="kthreshold";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="icomp1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="icomp2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="rtime";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="ftime";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DAM_instantiate;
	d->connect_port = DAM_connect_port;
	d->activate = dam_activate;
	d->run = dam_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = dam_cleanup;
	return d;
}

enum descriptor_enum {
	dam_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *dam_desc_pointer;

	if (!inited) {
		dam_desc_pointer = new_dam_desc();

		inited=true;
	}
	
	switch(Index) {
		case dam_desc_enum : return dam_desc_pointer;

		default:
			return 0;
	}
}
