
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "bowed.h"


LADSPA_Handle
BOWED_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BOWED * i = new BOWED;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BOWED_port_enum {
	BOWED_ar_enum, BOWED_amp_enum, BOWED_frequency_enum, BOWED_bowPress_enum, BOWED_betaRatio_enum, BOWED_decay_enum, BOWED_vibFreq_enum, BOWED_vibAmt_enum, BOWED_ifn_enum, BOWED_lowestFreq_enum, 
};

void
BOWED_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BOWED * ins = (BOWED *)Instance;
	switch(Port) {

		case BOWED_ar_enum:
			ins->ar = DataLocation;
			break;

		case BOWED_amp_enum:
			ins->amp = DataLocation;
			break;

		case BOWED_frequency_enum:
			ins->frequency = DataLocation;
			break;

		case BOWED_bowPress_enum:
			ins->bowPress = DataLocation;
			break;

		case BOWED_betaRatio_enum:
			ins->betaRatio = DataLocation;
			break;

		case BOWED_decay_enum:
			ins->decay = DataLocation;
			break;

		case BOWED_vibFreq_enum:
			ins->vibFreq = DataLocation;
			break;

		case BOWED_vibAmt_enum:
			ins->vibAmt = DataLocation;
			break;

		case BOWED_ifn_enum:
			ins->ifn = DataLocation;
			break;

		case BOWED_lowestFreq_enum:
			ins->lowestFreq = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

void
wgbow_activate(LADSPA_Handle Instance)
{
	BOWED * ins = (BOWED *)Instance;
	bowedset(ins);
}

void
wgbow_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BOWED * ins = (BOWED *)Instance;
	set_qcs_controlrate(SampleCount);
	bowed(ins);
}

void
wgbow_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_wgbow_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "wgbow";
	d->Name = "wgbow";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 10;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="amp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="frequency";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="bowPress";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="betaRatio";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="decay";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="vibFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="vibAmt";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="ifn";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="lowestFreq";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BOWED_instantiate;
	d->connect_port = BOWED_connect_port;
	d->activate = wgbow_activate;
	d->run = wgbow_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = wgbow_cleanup;
	return d;
}

enum descriptor_enum {
	wgbow_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *wgbow_desc_pointer;

	if (!inited) {
		wgbow_desc_pointer = new_wgbow_desc();

		inited=true;
	}
	
	switch(Index) {
		case wgbow_desc_enum : return wgbow_desc_pointer;

		default:
			return 0;
	}
}
