
#include "ladspa.h"

extern
void
set_qcs_framerate(unsigned long framerate);

extern
void
set_qcs_controlrate(unsigned long samplecount);
#include "biquad.h"


LADSPA_Handle
VCO_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	VCO * i = new VCO;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum VCO_port_enum {
	VCO_ar_enum, VCO_xamp_enum, VCO_xcps_enum, VCO_wave_enum, VCO_pw_enum, VCO_sine_enum, VCO_maxd_enum, 
};

void
VCO_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	VCO * ins = (VCO *)Instance;
	switch(Port) {

		case VCO_ar_enum:
			ins->ar = DataLocation;
			break;

		case VCO_xamp_enum:
			ins->xamp = DataLocation;
			break;

		case VCO_xcps_enum:
			ins->xcps = DataLocation;
			break;

		case VCO_wave_enum:
			ins->wave = DataLocation;
			break;

		case VCO_pw_enum:
			ins->pw = DataLocation;
			break;

		case VCO_sine_enum:
			ins->sine = DataLocation;
			break;

		case VCO_maxd_enum:
			ins->maxd = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
DISTORT_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	DISTORT * i = new DISTORT;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum DISTORT_port_enum {
	DISTORT_out_enum, DISTORT_in_enum, DISTORT_pregain_enum, DISTORT_postgain_enum, DISTORT_shape1_enum, DISTORT_shape2_enum, 
};

void
DISTORT_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	DISTORT * ins = (DISTORT *)Instance;
	switch(Port) {

		case DISTORT_out_enum:
			ins->out = DataLocation;
			break;

		case DISTORT_in_enum:
			ins->in = DataLocation;
			break;

		case DISTORT_pregain_enum:
			ins->pregain = DataLocation;
			break;

		case DISTORT_postgain_enum:
			ins->postgain = DataLocation;
			break;

		case DISTORT_shape1_enum:
			ins->shape1 = DataLocation;
			break;

		case DISTORT_shape2_enum:
			ins->shape2 = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BASIC_OP_ARG_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BASIC_OP_ARG * i = new BASIC_OP_ARG;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BASIC_OP_ARG_port_enum {
	
};

void
BASIC_OP_ARG_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BASIC_OP_ARG * ins = (BASIC_OP_ARG *)Instance;
	switch(Port) {

		default:
			break;
	}
}

LADSPA_Handle
NESTEDAP_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	NESTEDAP * i = new NESTEDAP;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum NESTEDAP_port_enum {
	NESTEDAP_out_enum, NESTEDAP_in_enum, NESTEDAP_mode_enum, NESTEDAP_maxdel_enum, NESTEDAP_del1_enum, NESTEDAP_gain1_enum, NESTEDAP_del2_enum, NESTEDAP_gain2_enum, NESTEDAP_del3_enum, NESTEDAP_gain3_enum, NESTEDAP_istor_enum, NESTEDAP_curp_enum, 
};

void
NESTEDAP_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	NESTEDAP * ins = (NESTEDAP *)Instance;
	switch(Port) {

		case NESTEDAP_out_enum:
			ins->out = DataLocation;
			break;

		case NESTEDAP_in_enum:
			ins->in = DataLocation;
			break;

		case NESTEDAP_mode_enum:
			ins->mode = DataLocation;
			break;

		case NESTEDAP_maxdel_enum:
			ins->maxdel = DataLocation;
			break;

		case NESTEDAP_del1_enum:
			ins->del1 = DataLocation;
			break;

		case NESTEDAP_gain1_enum:
			ins->gain1 = DataLocation;
			break;

		case NESTEDAP_del2_enum:
			ins->del2 = DataLocation;
			break;

		case NESTEDAP_gain2_enum:
			ins->gain2 = DataLocation;
			break;

		case NESTEDAP_del3_enum:
			ins->del3 = DataLocation;
			break;

		case NESTEDAP_gain3_enum:
			ins->gain3 = DataLocation;
			break;

		case NESTEDAP_istor_enum:
			ins->istor = DataLocation;
			break;

		case NESTEDAP_curp_enum:
			ins->curp = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
MOOGVCF_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	MOOGVCF * i = new MOOGVCF;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum MOOGVCF_port_enum {
	MOOGVCF_out_enum, MOOGVCF_in_enum, MOOGVCF_fco_enum, MOOGVCF_res_enum, MOOGVCF_max_enum, 
};

void
MOOGVCF_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	MOOGVCF * ins = (MOOGVCF *)Instance;
	switch(Port) {

		case MOOGVCF_out_enum:
			ins->out = DataLocation;
			break;

		case MOOGVCF_in_enum:
			ins->in = DataLocation;
			break;

		case MOOGVCF_fco_enum:
			ins->fco = DataLocation;
			break;

		case MOOGVCF_res_enum:
			ins->res = DataLocation;
			break;

		case MOOGVCF_max_enum:
			ins->max = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
PAREQ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PAREQ * i = new PAREQ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PAREQ_port_enum {
	PAREQ_out_enum, PAREQ_in_enum, PAREQ_fc_enum, PAREQ_v_enum, PAREQ_q_enum, PAREQ_mode_enum, 
};

void
PAREQ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PAREQ * ins = (PAREQ *)Instance;
	switch(Port) {

		case PAREQ_out_enum:
			ins->out = DataLocation;
			break;

		case PAREQ_in_enum:
			ins->in = DataLocation;
			break;

		case PAREQ_fc_enum:
			ins->fc = DataLocation;
			break;

		case PAREQ_v_enum:
			ins->v = DataLocation;
			break;

		case PAREQ_q_enum:
			ins->q = DataLocation;
			break;

		case PAREQ_mode_enum:
			ins->mode = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
REZZY_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	REZZY * i = new REZZY;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum REZZY_port_enum {
	REZZY_out_enum, REZZY_in_enum, REZZY_fco_enum, REZZY_rez_enum, REZZY_mode_enum, 
};

void
REZZY_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	REZZY * ins = (REZZY *)Instance;
	switch(Port) {

		case REZZY_out_enum:
			ins->out = DataLocation;
			break;

		case REZZY_in_enum:
			ins->in = DataLocation;
			break;

		case REZZY_fco_enum:
			ins->fco = DataLocation;
			break;

		case REZZY_rez_enum:
			ins->rez = DataLocation;
			break;

		case REZZY_mode_enum:
			ins->mode = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
BIQUAD_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	BIQUAD * i = new BIQUAD;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum BIQUAD_port_enum {
	BIQUAD_out_enum, BIQUAD_in_enum, BIQUAD_b0_enum, BIQUAD_b1_enum, BIQUAD_b2_enum, BIQUAD_a0_enum, BIQUAD_a1_enum, BIQUAD_a2_enum, BIQUAD_reinit_enum, 
};

void
BIQUAD_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	BIQUAD * ins = (BIQUAD *)Instance;
	switch(Port) {

		case BIQUAD_out_enum:
			ins->out = DataLocation;
			break;

		case BIQUAD_in_enum:
			ins->in = DataLocation;
			break;

		case BIQUAD_b0_enum:
			ins->b0 = DataLocation;
			break;

		case BIQUAD_b1_enum:
			ins->b1 = DataLocation;
			break;

		case BIQUAD_b2_enum:
			ins->b2 = DataLocation;
			break;

		case BIQUAD_a0_enum:
			ins->a0 = DataLocation;
			break;

		case BIQUAD_a1_enum:
			ins->a1 = DataLocation;
			break;

		case BIQUAD_a2_enum:
			ins->a2 = DataLocation;
			break;

		case BIQUAD_reinit_enum:
			ins->reinit = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
LORENZ_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	LORENZ * i = new LORENZ;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum LORENZ_port_enum {
	LORENZ_outx_enum, LORENZ_outy_enum, LORENZ_outz_enum, LORENZ_s_enum, LORENZ_r_enum, LORENZ_b_enum, LORENZ_hstep_enum, LORENZ_inx_enum, LORENZ_iny_enum, LORENZ_inz_enum, LORENZ_skip_enum, 
};

void
LORENZ_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	LORENZ * ins = (LORENZ *)Instance;
	switch(Port) {

		case LORENZ_outx_enum:
			ins->outx = DataLocation;
			break;

		case LORENZ_outy_enum:
			ins->outy = DataLocation;
			break;

		case LORENZ_outz_enum:
			ins->outz = DataLocation;
			break;

		case LORENZ_s_enum:
			ins->s = DataLocation;
			break;

		case LORENZ_r_enum:
			ins->r = DataLocation;
			break;

		case LORENZ_b_enum:
			ins->b = DataLocation;
			break;

		case LORENZ_hstep_enum:
			ins->hstep = DataLocation;
			break;

		case LORENZ_inx_enum:
			ins->inx = DataLocation;
			break;

		case LORENZ_iny_enum:
			ins->iny = DataLocation;
			break;

		case LORENZ_inz_enum:
			ins->inz = DataLocation;
			break;

		case LORENZ_skip_enum:
			ins->skip = DataLocation;
			break;

		default:
			break;
	}
}

LADSPA_Handle
PLANET_instantiate(const LADSPA_Descriptor* Descriptor, unsigned long SampleRate)
{
	PLANET * i = new PLANET;
	LADSPA_Handle h = i;
	set_qcs_framerate(SampleRate);
	return h;
}

enum PLANET_port_enum {
	PLANET_outx_enum, PLANET_outy_enum, PLANET_outz_enum, PLANET_mass1_enum, PLANET_mass2_enum, PLANET_sep_enum, PLANET_xval_enum, PLANET_yval_enum, PLANET_zval_enum, PLANET_vxval_enum, PLANET_vyval_enum, PLANET_vzval_enum, PLANET_delta_enum, PLANET_fric_enum, 
};

void
PLANET_connect_port(	LADSPA_Handle Instance,
                        unsigned long Port,
                        LADSPA_Data * DataLocation)
{
	PLANET * ins = (PLANET *)Instance;
	switch(Port) {

		case PLANET_outx_enum:
			ins->outx = DataLocation;
			break;

		case PLANET_outy_enum:
			ins->outy = DataLocation;
			break;

		case PLANET_outz_enum:
			ins->outz = DataLocation;
			break;

		case PLANET_mass1_enum:
			ins->mass1 = DataLocation;
			break;

		case PLANET_mass2_enum:
			ins->mass2 = DataLocation;
			break;

		case PLANET_sep_enum:
			ins->sep = DataLocation;
			break;

		case PLANET_xval_enum:
			ins->xval = DataLocation;
			break;

		case PLANET_yval_enum:
			ins->yval = DataLocation;
			break;

		case PLANET_zval_enum:
			ins->zval = DataLocation;
			break;

		case PLANET_vxval_enum:
			ins->vxval = DataLocation;
			break;

		case PLANET_vyval_enum:
			ins->vyval = DataLocation;
			break;

		case PLANET_vzval_enum:
			ins->vzval = DataLocation;
			break;

		case PLANET_delta_enum:
			ins->delta = DataLocation;
			break;

		case PLANET_fric_enum:
			ins->fric = DataLocation;
			break;

		default:
			break;
	}
}

void
vco_activate(LADSPA_Handle Instance)
{
	VCO * ins = (VCO *)Instance;
	vcoset(ins);
}

void
vco_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	VCO * ins = (VCO *)Instance;
	set_qcs_controlrate(SampleCount);
	vco(ins);
}

void
vco_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_vco_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "vco";
	d->Name = "vco";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 7;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="ar";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="xamp";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="xcps";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="wave";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="pw";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="sine";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="maxd";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = VCO_instantiate;
	d->connect_port = VCO_connect_port;
	d->activate = vco_activate;
	d->run = vco_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = vco_cleanup;
	return d;
}

void
nestedap_activate(LADSPA_Handle Instance)
{
	NESTEDAP * ins = (NESTEDAP *)Instance;
	nestedapset(ins);
}

void
nestedap_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	NESTEDAP * ins = (NESTEDAP *)Instance;
	set_qcs_controlrate(SampleCount);
	nestedap(ins);
}

void
nestedap_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_nestedap_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "nestedap";
	d->Name = "nestedap";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 11;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="mode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="maxdel";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="del1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="gain1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="del2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="gain2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="del3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="gain3";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="istor";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = NESTEDAP_instantiate;
	d->connect_port = NESTEDAP_connect_port;
	d->activate = nestedap_activate;
	d->run = nestedap_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = nestedap_cleanup;
	return d;
}

void
moogvcf_activate(LADSPA_Handle Instance)
{
	MOOGVCF * ins = (MOOGVCF *)Instance;
	moogvcfset(ins);
}

void
moogvcf_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	MOOGVCF * ins = (MOOGVCF *)Instance;
	set_qcs_controlrate(SampleCount);
	moogvcf(ins);
}

void
moogvcf_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_moogvcf_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "moogvcf";
	d->Name = "moogvcf";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="fco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="res";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="max";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = MOOGVCF_instantiate;
	d->connect_port = MOOGVCF_connect_port;
	d->activate = moogvcf_activate;
	d->run = moogvcf_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = moogvcf_cleanup;
	return d;
}

void
lorenz_activate(LADSPA_Handle Instance)
{
	LORENZ * ins = (LORENZ *)Instance;
	lorenzset(ins);
}

void
lorenz_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	LORENZ * ins = (LORENZ *)Instance;
	set_qcs_controlrate(SampleCount);
	lorenz(ins);
}

void
lorenz_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_lorenz_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "lorenz";
	d->Name = "lorenz";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 11;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="outx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="outy";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[2]="outz";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="s";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="r";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="b";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="hstep";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="inx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="iny";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="inz";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="skip";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = LORENZ_instantiate;
	d->connect_port = LORENZ_connect_port;
	d->activate = lorenz_activate;
	d->run = lorenz_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = lorenz_cleanup;
	return d;
}

void
rezzy_activate(LADSPA_Handle Instance)
{
	REZZY * ins = (REZZY *)Instance;
	rezzyset(ins);
}

void
rezzy_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	REZZY * ins = (REZZY *)Instance;
	set_qcs_controlrate(SampleCount);
	rezzy(ins);
}

void
rezzy_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_rezzy_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "rezzy";
	d->Name = "rezzy";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 5;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="fco";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="rez";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="mode";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = REZZY_instantiate;
	d->connect_port = REZZY_connect_port;
	d->activate = rezzy_activate;
	d->run = rezzy_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = rezzy_cleanup;
	return d;
}

void
biquad_activate(LADSPA_Handle Instance)
{
	BIQUAD * ins = (BIQUAD *)Instance;
	biquadset(ins);
}

void
biquad_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	BIQUAD * ins = (BIQUAD *)Instance;
	set_qcs_controlrate(SampleCount);
	biquad(ins);
}

void
biquad_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_biquad_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "biquad";
	d->Name = "biquad";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 9;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="b0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="b1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="b2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="a0";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="a1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="a2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="reinit";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = BIQUAD_instantiate;
	d->connect_port = BIQUAD_connect_port;
	d->activate = biquad_activate;
	d->run = biquad_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = biquad_cleanup;
	return d;
}

void
distort1_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	DISTORT * ins = (DISTORT *)Instance;
	set_qcs_controlrate(SampleCount);
	distort(ins);
}

void
distort1_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_distort1_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "distort1";
	d->Name = "distort1";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 6;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="out";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[1]="in";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[2]="pregain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="postgain";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="shape1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="shape2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = DISTORT_instantiate;
	d->connect_port = DISTORT_connect_port;
	d->activate = 0;
	d->run = distort1_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = distort1_cleanup;
	return d;
}

void
planet_activate(LADSPA_Handle Instance)
{
	PLANET * ins = (PLANET *)Instance;
	planetset(ins);
}

void
planet_run(LADSPA_Handle Instance, unsigned long SampleCount)
{
	PLANET * ins = (PLANET *)Instance;
	set_qcs_controlrate(SampleCount);
	planet(ins);
}

void
planet_cleanup(LADSPA_Handle)
{
}

LADSPA_Descriptor*
new_planet_desc()
{
	LADSPA_Descriptor* d = new LADSPA_Descriptor;
	d->UniqueID=0;
	d->Label = "planet";
	d->Name = "planet";
	d->Maker = "";
	d->Copyright = "GPL or MIT";
	d->PortCount = 14;
	d->PortDescriptors = new LADSPA_PortDescriptor[d->PortCount];
	d->PortNames = new const char *[d->PortCount];
	d->PortRangeHints = new LADSPA_PortRangeHint[d->PortCount];
	for(int i=0; i<d->PortCount; ++i) {

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[0]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[0]="outx";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[0].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[1]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[1]="outy";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[1].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[2]=LADSPA_PORT_AUDIO | LADSPA_PORT_OUTPUT;
		const_cast<const char**>(d->PortNames)[2]="outz";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[2].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[3]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[3]="mass1";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[3].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[4]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[4]="mass2";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[4].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[5]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[5]="sep";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[5].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[6]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[6]="xval";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[6].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[7]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[7]="yval";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[7].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[8]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[8]="zval";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[8].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[9]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[9]="vxval";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[9].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[10]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[10]="vyval";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[10].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[11]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[11]="vzval";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[11].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[12]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[12]="delta";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[12].HintDescriptor=0;

		const_cast<LADSPA_PortDescriptor*>(d->PortDescriptors)[13]=LADSPA_PORT_CONTROL | LADSPA_PORT_INPUT;
		const_cast<const char**>(d->PortNames)[13]="fric";
		const_cast<LADSPA_PortRangeHint*>(d->PortRangeHints)[13].HintDescriptor=0;

	}
	d->ImplementationData = 0;
	d->instantiate = PLANET_instantiate;
	d->connect_port = PLANET_connect_port;
	d->activate = planet_activate;
	d->run = planet_run;
	d->run_adding = 0;
	d->set_run_adding_gain = 0;
	d->deactivate = 0;
	d->cleanup = planet_cleanup;
	return d;
}

enum descriptor_enum {
	vco_desc_enum, distort1_desc_enum, moogvcf_desc_enum, nestedap_desc_enum, rezzy_desc_enum, biquad_desc_enum, lorenz_desc_enum, planet_desc_enum, 
};

const LADSPA_Descriptor *
ladspa_descriptor(unsigned long Index)
{
	static bool inited=false;
	static LADSPA_Descriptor *vco_desc_pointer;
	static LADSPA_Descriptor *distort1_desc_pointer;
	static LADSPA_Descriptor *moogvcf_desc_pointer;
	static LADSPA_Descriptor *nestedap_desc_pointer;
	static LADSPA_Descriptor *rezzy_desc_pointer;
	static LADSPA_Descriptor *biquad_desc_pointer;
	static LADSPA_Descriptor *lorenz_desc_pointer;
	static LADSPA_Descriptor *planet_desc_pointer;

	if (!inited) {
		vco_desc_pointer = new_vco_desc();
		distort1_desc_pointer = new_distort1_desc();
		moogvcf_desc_pointer = new_moogvcf_desc();
		nestedap_desc_pointer = new_nestedap_desc();
		rezzy_desc_pointer = new_rezzy_desc();
		biquad_desc_pointer = new_biquad_desc();
		lorenz_desc_pointer = new_lorenz_desc();
		planet_desc_pointer = new_planet_desc();

		inited=true;
	}
	
	switch(Index) {
		case vco_desc_enum : return vco_desc_pointer;
		case distort1_desc_enum : return distort1_desc_pointer;
		case moogvcf_desc_enum : return moogvcf_desc_pointer;
		case nestedap_desc_enum : return nestedap_desc_pointer;
		case rezzy_desc_enum : return rezzy_desc_pointer;
		case biquad_desc_enum : return biquad_desc_pointer;
		case lorenz_desc_enum : return lorenz_desc_pointer;
		case planet_desc_enum : return planet_desc_pointer;

		default:
			return 0;
	}
}
