/*
    Copyright (C) 1998-99 Paul Barton-Davis 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: memfile.h,v 1.2 1999/11/08 08:00:36 stef Exp $
*/

#ifndef __qm_memfile_h__
#define __qm_memfile_h__

#include <string>
#include <map>
#include <sys/types.h>

#include <pbd/rcpointer.h>

class MemoryMappedFileCache;

class MemoryMappedFile { 
  public:
	char	*beginp;  /* Csound historic naming */
	char	*endp;    /* Csound historic naming */

  protected:
	int count;
	friend class RCPointer<MemoryMappedFile>;

  protected:
	MemoryMappedFile (const string &path);
	virtual ~MemoryMappedFile ();
	friend class MemoryMappedFileCache;

  private:
	size_t	length;
};

class MemoryMappedFileCache : public map<const char *, 
			      RCPointer<MemoryMappedFile> >

{
  public:
	RCPointer<MemoryMappedFile> open (const string &path);
	int close (const string &path);
};

extern MemoryMappedFileCache memoryfiles;

#endif // __qm_memfile_h__
