/*
    Copyright (C) 1998-99 Paul Barton-Davis 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: dynamic_memory.h,v 1.3 1999/11/17 13:13:33 pbd Exp $
*/

#ifndef __qm_dynamic_memory_h__
#define __qm_dynamic_memory_h__

#include <memory.h>
#include <vector>

#define auxalloc(p,s,m) m->alloc(s)

class DynamicMemory {
   public:
        DynamicMemory() { 
		size = 0;
		auxp = NULL;
		endp = NULL;
	}

        ~DynamicMemory () {
		release ();
	}
        
        void alloc (size_t sz) {
		release ();
		auxp = new char[sz];
		memset (auxp, 0, sz);
		endp = auxp + sz;
		size = sz;
	}

	size_t   size;
	char    *auxp; /* historic naming */
	char    *endp; /* historic naming */ 

    private:
        void release () {
		if (auxp) delete [] auxp;
	}
};

typedef DynamicMemory AUXCH; /* historic naming */
typedef std::vector<DynamicMemory *> DynamicMemoryList;

#endif // __qm_dynamic_memory_h__
