/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: vdelay.h,v 1.1 1999/11/01 04:29:08 pbd Exp $
*/


#ifndef __vdelay_h__
#define __vdelay_h__

/*	vdelay, multitap, reverb2 coded by Paris Smaragdis		*/
/*	Berklee College of Music Csound development team		*/
/*	Copyright (c) December 1994.  All rights reserved		*/

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>

#define	Combs	6
#define	Alpas	5

OpcodeArgument(NREV)
	Number	*out, *in, *time, *hdif, *istor;
	Number	*cbuf_cur[Combs], *abuf_cur[Alpas];
	Number	c_time[Combs], c_gain[Combs], a_time[Alpas], a_gain[Alpas];
	Number	z[Combs], g[Combs];
        AUXCH	temp;
	AUXCH	caux[Combs], aaux[Alpas];
	Number	prev_time, prev_hdif;
};


OpcodeArgument(VDEL)
	Number	*sr, *ain, *adel, *imaxd, *istod;
	AUXCH	aux;
	long	left;
};

OpcodeArgument(MDEL)
	Number	*sr, *ain, *ndel[VARGMAX];
	AUXCH	aux;
	long	left, max;
};

#define	Combs	6
#define	Alpas	5

OpcodeArgument(STVB)
	Number	*out, *in, *time, *hdif, *istor;
	Number	*cbuf_cur[Combs], *abuf_cur[Alpas];
	Number	c_time[Combs], c_gain[Combs], a_time[Alpas], a_gain[Alpas];
	Number	z[Combs], g[Combs];
        AUXCH	temp;
	AUXCH	caux[Combs], aaux[Alpas];
	Number	prev_time, prev_hdif;
};

extern void vdelset (VDEL *p);
extern void vdelay (VDEL *p);
extern void multitap_set (MDEL *p);
extern void multitap_play (MDEL *p);
extern bool prime (int val);
extern void nreverb_set (NREV *p);
extern void nreverb (NREV *p);

#define VDELAY_OPCODE_LIST \
{"reverb2", S(NREV), InitTime|AudioTime, "a", "akko", \
	 F(nreverb_set), NULL, F(nreverb)}, \
{"nreverb", S(NREV), InitTime|AudioTime, "a", "akko", \
	 F(nreverb_set), NULL, F(nreverb)}, \
{"vdelay", S(VDEL), InitTime|AudioTime, "a", "axio", \
	 F(vdelset), NULL, F(vdelay)}, \
{"multitap", S(MDEL), InitTime|AudioTime, "a", "am", \
	 F(multitap_set), NULL, F(multitap_play)}


#endif __vdelay_h__

