#ifndef __vibraphn_h__
#define __vibraphn_h__

/*******************************************/
/*  Vibraphone SubClass of Modal4          */
/*  Module, by Perry R. Cook, 1995-96  */ 
/*                                         */
/*   Controls:    stickHardness 	   */
/*                strikePosition           */
/*		  vibFreq                  */
/*		  vibAmt                   */
/*******************************************/

#include "modal4.h"

typedef struct Vibraphn {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amplitude, *frequency;
    float	*hardness, *spos, *ifn;
    float	*vibFreq, *vibAmt, *ivfn, *dettack;

    Modal4	m4;
    float	strikePosition;
    float	stickHardness;
    int		kloop;
} VIBRAPHN;

extern void vibraphnset (VIBRAPHN *p);
extern void vibraphn (VIBRAPHN *p);
extern void agogobelset (VIBRAPHN *p);
extern void agogobel (VIBRAPHN *p);

#endif __vibraphn_h__
