#ifndef __ugrw1_h__
#define __ugrw1_h__


							/*	UGRW1.H	*/
/* These files are based on Robin Whittle's
 *       ugrw1.c of 27 August 1996 
 * and   ugrw1.h of 7 January 1995
 *
 * In February 1997, John Fitch reformatted the comments and 
 * cleaned up some code in printksset() - which was working fine
 * but was inelegantly coded.
 *
 *
 * Copyright notice - Robin Whittle  25 February 1997
 * 
 * Documentation files, and the original .c and .h files, with more 
 * spaced out comments, are available from http://www.firstpr.com.au
 *
 * The code in both ugrw1 and ugrw2 is copyright Robin Whittle.
 * Permission is granted to use this in whole or in part for any 
 * purpose, provided this copyright notice remains intact and 
 * any alterations to the source code, including comments, are 
 * clearly indicated as such.
 */

/*
 *	Unit generators by Robin Whittle 		6 January 1996
 *	Header file containing data structures for UGRW1.C.
 */

/* TABLEW data structure used by all the tablew subroutines. */	

typedef struct {
	OPDS	h;
	float	*xsig;		/* Input value to write to table. */ 
        float	*xndx;		/* Index into the table where want to write */
	float	*xfn;		/* Number of table we are writing to. */
        float	*ixmode;	/* Index mode (optional parm).
				 * 0 --> Use raw xfn and ixoff.
				 * 1 --> Use these with a range of 0 to 1 for
				 * the entire range of the table. */
	float	*ixoff;		/* Offset (opt). Fixed value to add to ndx*/
        float	*iwgmode;	/* Wrap and guard point mode (optional)
				 * 	0 --> Limit indx to between 0 table len
				 *	1 --> Index wraps around modulo len
				 *	2 --> Write with 0.5 step offset, and
				 *            write both 0 and guard with the 
				 *	       same data.  */

	/* Internal variable for previous state of xfn.  */
	long	pfn;		/* Internal variable for what to multiply 
				 * the ndx and ixoff by. Set to 1 or table 
				 * length by tblwset() depending on ixmode.
				 */
	long   	xbmul; 		/* Internal variable for iwrap and igmode. */
	long	iwgm;		/* Internal variable for offset. */
	float	offset;		/* Pointer to data structure used to access 
				 * function table. tblwset() writes this, based
				 * on the value of xfn.
				 */
	FUNC	*ftp;
} TABLEW;

/* TABLENG data structure used by function tableng to return the
 * length of the table. */

typedef struct {
	OPDS	h;
	float	*kout;		/* Output pointer */
	float	*xfn;		/* Points to the number of the table. */
} TABLENG;


/* TABLEGPW data structure used by function tablegpw to write the
 * guard point of a specified table. (No output arguments) */

typedef struct {
	OPDS	h;
	float	*xfn;		/* Points to number of table. */
} TABLEGPW;

/* TABLEMIX data structure used by function tablemix. */	

typedef struct {
	OPDS	h;
	float	*dft, *doff, *len, *s1ft, *s1off, *s1g, *s2ft, *s2off, *s2g;

	/* Storage to remember what the table numbers were from a previous k
	   cycle, and to store pointers to their FUNC data structures. */
	int	pdft;		/* Previous destination */
	int	ps1ft, ps2ft;	/* source function table numbers. */
	FUNC	*funcd, *funcs1, *funcs2;
} TABLEMIX;

/* TABLECOPY data structure used by function tablecopy. */	

typedef struct {
	OPDS	h;
	float	*dft;		/* Destination function table number. */
        float	*sft;		/* Source function table number */

	/* Storage to remember what the table numbers were from a previous k
	   cycle, and to store pointers to their FUNC data structures. */
	int	pdft;		/* Previous destination */
	int	psft;		/* source function table numbers. */
	FUNC	*funcd, *funcs;
} TABLECOPY;

/* TABLERA data structure used by tablera subroutine. */	

typedef struct {
	OPDS	h;
	float	*adest;		/* A rate destination */
	float	*kfn;		/* Number of table read */
	float	*kstart;	/* Index mode within table */
	float	*koff;		/* Offset to add to table index */

	/* Internal variable for previous state of xfn. */
	long	pfn;		/* Pointer to function table data structure */
	FUNC	*ftp;
} TABLERA;

/* TABLEWA data structure used by tablewa subroutine. */	

typedef struct {
	OPDS	h;
	float	*kstart;	/* Index mode within table we start reading.
				 * Note this is also an input argument.  First
				 * we read it to determine where we should start
				 * writing the a rate samples. When we have
				 * finished we write to it the number of the
				 * next location which should be written. */
        float	*kfn;		/* Number of table we are reading from. */
	float	*asig;		/* a rate input signal. */
        float	*koff;		/* Offset to add to table index. */

	long	pfn;		/* Pointer to function table. */
	FUNC	*ftp;
} TABLEWA;

/*****************************************************************************/

/* Data structures for the zak family of ugens for patching data at i,
 * k or a rates. 
 * See also four global variables declared in the C code.  */

/* ZAKINIT data structure for zakinit(). */	
typedef struct {
	OPDS	h;
	float	*isizea;	/* Number of a locations, each an array of
				 * ksmps long, to to reserve for a rate
				 * patching */
	float	*isizek;	/* Number of locations for i or k rate
				 * variables */
} ZAKINIT;

/* ZKR data structure for zir() and zkr(). */
typedef struct {
	OPDS	h;
	float	*rslt;		/* Where to write the value read from zk */
	float	*ndx;		/* Location in zk space to read */
} ZKR;

/* ZKW data structure for ziw() and zkw(). */	
typedef struct {
	OPDS	h;
	float	*sig;		/* Value to write */
        float	*ndx;		/* Locations to read */
} ZKW;

/* ZKWM data structure for ziwm() and zkwm(). */	
typedef struct {
	OPDS	h;
	float	*sig;		/* Value to write */
        float	*ndx;		/* Locations to read */
        float	*mix;		/* 0 for write directly;  !0 for mix - add in */

} ZKWM;

/* ZKMOD data structure for zkmod(). */	
typedef struct {
	OPDS	h;
	float	*rslt;		/* Points to where to write output */
	float	*sig;		/* Value to modulate */
	float	*zkmod;		/* Which zk variable to use to modulate sig */

} ZKMOD;

/* ZKCL data structure for zkcl(). */
typedef struct {
	OPDS	h;
	float	*first;		/* First variable to clear */
	float	*last;		/* Final variable to clear */

} ZKCL;

/* ZAR data structure for zar(). */	
typedef struct {
	OPDS	h;
	float	*rslt;		/* Where to write the value */
	float	*ndx;		/* Location in za space to read */

} ZAR;

/* ZARG data structure for zarg(). */	
typedef struct {
	OPDS	h;
	float	*rslt;		/* Where to write the zk location */
        float	*ndx;		/* Location in za space to read */
	float	*kgain;		/* Gain to be given to signal read */
} ZARG;

/* ZAW data structure for zaw(). */	
typedef struct {
	OPDS	h;
	float	*sig, *ndx;
} ZAW;


/* ZAWM data structure for zawm(). */	
typedef struct {
	OPDS	h;
	float	*sig;
	float	*ndx, *mix;	/* Locations to read; 0 for write directly, or addd in */
} ZAWM;

/* ZAWOD data structure for zamod(). */	
typedef struct {
	OPDS	h;
	float	*rslt;
	float	*sig, *zamod;	/* Value to modulate; Which za variable to use */
} ZAMOD;

/* ZACL data structure for zacl(). */	
typedef struct {
	OPDS	h;
	float	*first, *last;
} ZACL;


/*****************************************************************************/
				
/* RDTIME data structure for timek(), times(), instimset(), instimek()
   and instimes().  */

typedef struct {
	OPDS	h;
	float 	*rslt;
	long	instartk;
} RDTIME;


/*****************************************************************************/
				
	/* PRINTK data structure for printk() and printkset(). */
typedef struct {
	OPDS	h;
	float 	*ptime;		/* How much time to leave between each print*/
	float	*val;		/* Value to print */
	float	*space;		/* Spaces to insert before printing */
	float	initime, ctime;	/* Time when initialised; initialised */
	long	pspace;		/* How many spaces to print */
        long	cysofar;	/* Number of print cycles so far */
} PRINTK;

/* PRINTKS data structure for printks() and printksset()  */
typedef struct {
	OPDS	h;
	float 	*ifilcod;	/* File name */
	float	*ptime;		/* How much time to leave between each print */
	float	*kval1, *kval2, *kval3, *kval4;	/* values to print */
	float	initime, ctime;	/* Time when initialised; Cycle time */
	long	cysofar;	/* Number of print cycles so far from 0 */
	char	txtstring[260];	/* Place to store the string printed */
} PRINTKS;

/*****************************************************************************/


/* PEAK data structure for peakk() and peaka(). */	
typedef struct {
	OPDS	h;
	float 	*kpeakout;	/* Pointer to k or a rate input variable. */
	float 	*xsigin;	/* Pointer to k rate input variable which, 
				 * if set to no zero, causes the ugen to 
				 * clear the accumulator.	 */
} PEAK;

typedef struct {
	OPDS	h;
	float 	*val, *space;
	float	oldvalue;
	int	pspace;
		
} PRINTK2;



extern int itblchkw (TABLEW *p);
extern void ptblchkw (TABLEW *p);
extern void tblsetw (TABLEW *p);
extern void tblsetwkt (TABLEW *p);
extern void itablew (TABLEW *p);
extern void ktablew (TABLEW *);
extern void ktablew (TABLEW *p);
extern void tablew (TABLEW *p);
extern int ftkrchkw (TABLEW *p);
extern void ktablewkt (TABLEW *p);
extern void tablewkt (TABLEW *p);
extern void tableng (TABLENG *p);
extern void itableng (TABLENG *p);
extern void tablegpw (TABLEGPW *p);
extern void itablegpw (TABLEGPW *p);
extern void tablemixset (TABLEMIX *p);
extern void domix (TABLEMIX *);
extern void tablemix (TABLEMIX *p);
extern void itablemix (TABLEMIX *p);
extern void domix (TABLEMIX *p);
extern void tablecopyset (TABLECOPY *p);
extern void docopy (TABLECOPY *);
extern void tablecopy (TABLECOPY *p);
extern void itablecopy (TABLECOPY *p);
extern void docopy (TABLECOPY *p);
extern void tableraset (TABLERA *p);
extern void tablera (TABLERA *p);
extern void tablewaset (TABLEWA *p);
extern void tablewa (TABLEWA *p);
extern void zakinit (ZAKINIT *p);
extern int zkset (void);
extern void zkr (ZKR *p);
extern void zir (ZKR *p);
extern void zkw (ZKW *p);
extern void ziw (ZKW *p);
extern void zkwm (ZKWM *p);
extern void ziwm (ZKWM *p);
extern void zkmod (ZKMOD *p);
extern void zkcl (ZKCL *p);
extern int zaset (ZAR *p);
extern void zar (ZAR *p);
extern void zarg (ZARG *p);
extern void zaw (ZAW *p);
extern void zawm (ZAWM *p);
extern void zamod (ZAMOD *p);
extern void zacl (ZACL *p);
extern void timek (RDTIME *p);
extern void timesr (RDTIME *p);
extern void instimset (RDTIME *p);
extern void instimek (RDTIME *p);
extern void instimes (RDTIME *p);
extern void printkset (PRINTK *p);
extern void printk (PRINTK *p);
extern void printksset (PRINTKS *p);
extern void printks (PRINTKS *p);
extern void peakk (PEAK *p);
extern void peaka (PEAK *p);
extern void printk2set (PRINTK2 *p);
extern void printk2 (PRINTK2 *p);


#endif __ugrw1_h__

