#include <math.h>
#include "cs.h"
#include "entry.h"
#include "ugens8.h"
#include "insert.h"
#include "auxfd.h"
#include "fgens.h"
#include "dsputil.h"
#include "fft.h"
#include "pvoc.h"
#include "pvocext.h"
#include "soundio.h"
#include "oload.h"
#include "memfiles.h"

/******************************************/
/* Originated by Dan Ellis, MIT */
/* Spectral Extraction and Amplitude Gating */
/* added by Richard Karpen, University */
/* of Washington, Seattle 1998 */
/******************************************/


#define WLN   1			/* time window is WLN*2*ksmps long */

#define OPWLEN (2*WLN*ksmps)	/* manifest used for final time wdw */


void
pvset(PVOC * p)
{
	int i;
	long memsize;
	char pvfilnam[MAXNAME];
	MEMFIL *mfp;
	PVSTRUCT *pvh;
	int frInc, chans, size;	/* THESE SHOULD BE SAVED IN PVOC STRUCT
				 */
	FUNC *AmpGateFunc;


	if (*p->ifilno == sstrcod)	/* if strg name given */
		strcpy(pvfilnam, p->STRARG);	/*   use that         */
	else if ((long) *p->ifilno < strsmax && strsets != NULL &&
		 strsets[(long) *p->ifilno])
		strcpy(pvfilnam, strsets[(long) *p->ifilno]);
	else
		sprintf(pvfilnam, "pvoc.%d", (int) *p->ifilno);
	/* else pvoc.filnum   */
	if ((mfp = p->mfp) == NULL
	    || strcmp(mfp->filename, pvfilnam) != 0)	/* if file not
							   already readin */
		if ((mfp = ldmemfile(pvfilnam)) == NULL) {
			error << "PVOC cannot load " << pvfilnam << endmsg;

			goto pverr;
		}
	pvh = (PVSTRUCT *) mfp->beginp;
	if (pvh->magic != PVMAGIC) {
		error << "" << pvfilnam << " not a PVOC file (magic " << pvh->magic << ")" << endmsg;

		goto pverr;
	}
	chans = pvh->channels;
	p->frSiz = pvh->frameSize;
	p->frPtr = (float *) ((char *) pvh + pvh->headBsize);
	p->baseFr = 0;		/* point to first data frame */
	p->maxFr = -1 + (pvh->dataBsize / (chans * (p->frSiz + 2) * sizeof
					   (float)));

	if (*p->imode == 1 || *p->imode == 2)
		memsize = (long) (PVDATASIZE + PVFFTSIZE * 3 + PVWINLEN +
				  ((p->frSiz + 2L) * (p->maxFr + 2)));
	else
		memsize = (long) (PVDATASIZE + PVFFTSIZE * 3 + PVWINLEN);

	if (p->auxch.auxp == NULL || memsize != p->mems) {
		register float *fltp;
		auxalloc((memsize * sizeof (float)), &p->auxch);
		fltp = (float *) p->auxch.auxp;
		p->lastPhase = fltp;
		fltp += PVDATASIZE;	/* and insert addresses */
		p->fftBuf = fltp;
		fltp += PVFFTSIZE;
		p->dsBuf = fltp;
		fltp += PVFFTSIZE;
		p->outBuf = fltp;
		fltp += PVFFTSIZE;
		p->window = fltp;
		if (*p->imode == 1 || *p->imode == 2) {
			fltp += PVWINLEN;
			p->pvcopy = fltp;
		}
	}
	p->mems = memsize;

	if ((p->asr = pvh->samplingRate) != esr) {	/* & chk the data */
		warning << "" << pvfilnam << "''s srate = " << p->asr << ", orch's srate = " << esr << endmsg;

	}
	if (pvh->dataFormat != PVFLOAT) {
		error << "unsupported PVOC data format " << pvh->dataFormat << " in " << pvfilnam << endmsg;

		goto pverr;
	}
	if (p->frSiz > PVFRAMSIZE) {
		error << "PVOC frame " << p->frSiz << " bigger than " << PVFRAMSIZE << " in " << pvfilnam << endmsg;

		goto pverr;
	}
	if (p->frSiz < 128) {
		error << "PVOC frame " << p->frSiz << " seems too small in " << pvfilnam << endmsg;

		goto pverr;
	}
	if (chans != 1) {
		error << "" << chans << " chans (not 1) in PVOC file " << pvfilnam << endmsg;

		goto pverr;
	}
	frInc = pvh->frameIncr;
	p->frPktim = ((float) ksmps) / ((float) frInc);
	/* factor by which to mult expand phase diffs (ratio of samp spacings)
	 */
	p->frPrtim = esr / ((float) frInc);
	/* factor by which to mulitply 'real' time index to get frame index */
	size = pvfrsiz(p);	/* size used in def of OPWLEN ? */
/*  p->scale = 4.*((float)ksmps)/((float)pvfrsiz(p)*(float)pvfrsiz(p)); */
/*    p->scale = 2.*((float)ksmps)/((float)OPWLEN*(float)pvfrsiz(p));   */
	p->scale = 32768.0f * 2.0f * ((float) ksmps) / ((float) OPWLEN *
						     (float) pvfrsiz(p));
	/* 2*incr/OPWLEN scales down for win ovlp, windo'd 1ce (but 2ce?) */
	/* 1/frSiz is the required scale down before (i)FFT */
	p->prFlg = 1;		/* true */
	p->opBpos = 0;
	p->lastPex = 1.0f;	/* needs to know last pitchexp to update
				   phase */
	/* Set up time window */
	for (i = 0; i < pvdasiz(p); ++i) {	/* or maybe pvdasiz(p) */
		/* p->window[i] =
		   (0.54-0.46*cos(2.0*pi*(float)i/(float)(pvfrsiz(p)))); */
		p->lastPhase[i] = 0.0f;
	}
	if ((OPWLEN / 2 + 1) > PVWINLEN) {
		error << "ksmps of " << ksmps << " needs wdw of " << (OPWLEN / 2 + 1) << ", max is " << PVWINLEN << " for pv " << pvfilnam << "\n" << endmsg;

		goto pverr;
	}
	if (*p->igatefun > 0)
		if ((AmpGateFunc = ftfind(p->igatefun)) == NULL)
			return;
	p->AmpGateFunc = AmpGateFunc;

	if (*p->igatefun > 0)
		p->PvMaxAmp = PvocMaxAmp(p->frPtr, size, p->maxFr);

	if (*p->imode == 1 || *p->imode == 2) {
		SpectralExtract(p->frPtr, p->pvcopy, size, p->maxFr, (int)
				*p->imode, *p->ifreqlim);
		p->frPtr = p->pvcopy;
	}
	for (i = 0; i < OPWLEN / 2 + 1; ++i)	/* time window is OPWLEN
						   long */
		p->window[i] = (0.54f - 0.46f * (float) cos(2.0 * pi * (double)
						   i / (double) OPWLEN));
	/* NB : HAMMING */
	for (i = 0; i < pvfrsiz(p); ++i)
		p->outBuf[i] = 0.0f;
	MakeSinc( /* p->sncTab */ );	/* sinctab is same for all
					   instances */
	p->plut = (float *) AssignBasis(NULL, pvfrsiz(p));	/* SET UP
								   NONET FFT */

      pverr:
	return;

}

void
pvoc(PVOC * p)
{
	float *ar = p->rslt;
	float frIndx;
	float *buf = p->fftBuf;
	float *buf2 = p->dsBuf;
	float *plut = p->plut;
	int asize = pvdasiz(p);	/* new */
	int size = pvfrsiz(p);
	int buf2Size, outlen;
	int circBufSize = PVFFTSIZE;
	int specwp = (int) *p->ispecwp;		/* spectral warping flag 
						 */
	float pex;


	if (p->auxch.auxp == NULL) {
		error << "INIT: pvoc: not initialized" << endmsg;

		return;
	}
/*     if (pdebug) { info << "<" << *p->ktimpnt << ">" << endmsg;
 fflush(stdout); } */
	pex = *p->kfmod;
	outlen = (int) (((float) size) / pex);
	/* use outlen to check window/krate/transpose combinations */
	if (outlen > PVFFTSIZE) {	/* Maximum transposition down is one
					   octave */
		/* ..so we won't run into buf2Size problems */
		error << "PERF: PVOC transpose too low" << endmsg;

		return;
	}
	if (outlen < 2 * ksmps) {	/* minimum post-squeeze windowlength
					 */
		error << "PERF: PVOC transpose too high" << endmsg;

		return;
	}
	buf2Size = OPWLEN;	/* always window to same length after DS */
	if ((frIndx = *p->ktimpnt * p->frPrtim) < 0) {
		error << "PERF: PVOC timpnt < 0" << endmsg;

		return;
	}
	if (frIndx > p->maxFr) {	/* not past last one */
		frIndx = (float) p->maxFr;
		if (p->prFlg) {
			p->prFlg = 0;	/* false */
			warning << "PVOC ktimpnt truncated to last frame" << endmsg;

		}
	}
	FetchIn(p->frPtr, buf, size, frIndx);

	if (*p->igatefun > 0)
		PvAmpGate(buf, size, p->AmpGateFunc, p->PvMaxAmp);

	FrqToPhase(buf, asize, pex * (float) ksmps, p->asr,
	/*a0.0 */ (float) (.5 * ((pex / p->lastPex) - 1)));
	/* Offset the phase to align centres of stretched windows, not starts
	 */
	RewrapPhase(buf, asize, p->lastPhase);

	if (specwp > 0)
		PreWarpSpec(buf, asize, pex);

	Polar2Rect(buf, asize);
	buf[1] = 0.0f;
	buf[size + 1] = 0.0f;	/* kill spurious imag at dc & fs/2 */
	FFT2torl((complex *) buf, size, 1, /*a pex */ p->scale, (complex *)
		 plut);
	/* CALL TO NONET FFT */
	PackReals(buf, size);
	if (pex != 1.0)
		UDSample(buf, (.5f * ((float) size - pex * (float) buf2Size))
		/*a */ , buf2, size, buf2Size, pex);
	else
		CopySamps(buf + (int) (.5 * ((float) size - pex * (float)
				     buf2Size)) /*a */ , buf2, buf2Size);
	ApplyHalfWin(buf2, p->window, buf2Size);
	addToCircBuf(buf2, p->outBuf, p->opBpos, ksmps, circBufSize);
	writeClrFromCircBuf(p->outBuf, ar, p->opBpos, ksmps, circBufSize);
	p->opBpos += ksmps;
	if (p->opBpos > circBufSize)
		p->opBpos -= circBufSize;
	addToCircBuf(buf2 + ksmps, p->outBuf, p->opBpos, buf2Size - ksmps,
		     circBufSize);
	p->lastPex = pex;	/* needs to know last pitchexp to update phase 
				 */
}





OENTRY opcodes[] =
{
	{"pvoc", S(PVOC), 5, "a", "kkSoooo", F(pvset), NULL, F(pvoc)},
	{NULL}
};
