#ifndef __pvinterp_h__
#define __pvinterp_h__


/*      					 		pvinterp.h    */

#include "ugens8.h"

typedef struct {
    OPDS    h;
    float  *ktimpnt, *ifilno;
    MEMFIL	*mfp;
    long    maxFr, frSiz, prFlg;
    /* base Frame (in frameData0) and maximum frame on file, ptr to fr, size */
    float   frPktim, frPrtim, asr, *frPtr;
    AUXCH   auxch;
    float   *lastPhase, *fftBuf;  /* [PVFFTSIZE] FFT works on Real & Imag */
	float	*buf;
} PVBUFREAD;


typedef struct {
    OPDS    h;
    float   *rslt, *ktimpnt, *kfmod, *ifilno, 
            *kfreqscale1, *kfreqscale2, *kampscale1, *kampscale2,
            *kfreqinterp, *kampinterp;

    MEMFIL  *mfp;
    long    kcnt;
    long    baseFr, maxFr, frSiz, prFlg, opBpos;
     /* base Frame (in frameData0) and maximum frame on file, ptr to fr, size */
    float   frPktim, frPrtim, scale, asr, *frPtr, lastPex, *plut;
     /* asr is analysis sample rate */
     /* fft frames per k-time (equals phase change expansion factor) */
    AUXCH   auxch;	/* manage AUXDS for the following 5 buffer spaces */
    float   *lastPhase; /* [PVDATASIZE]	Keep track of cum. phase */
    float   *fftBuf;	/* [PVFFTSIZE]	FFT works on Real & Imag */
    float   *dsBuf;	/* [PVFFTSIZE]	Output of downsampling may be 2x */
    float   *outBuf;	/* [PVFFTSIZE]	Output buffer over win length */
    float   *window;	/* [PVWINLEN]	Store 1/2 window */
    PVBUFREAD *pvbufread;

} PVINTERP;


typedef struct {
    OPDS    h;
    float   *rslt, *ktimpnt, *kfmod, *ifilno,
            *kampscale1, *kampscale2, *ispecwp;
    MEMFIL  *mfp;
    long    kcnt;
    long    baseFr, maxFr, frSiz, prFlg, opBpos;
     /* base Frame (in frameData0) and maximum frame on file, ptr to fr, size */
    float   frPktim, frPrtim, scale, asr, *frPtr, lastPex, *plut;
     /* asr is analysis sample rate */
     /* fft frames per k-time (equals phase change expansion factor) */
    AUXCH   auxch;	/* manage AUXDS for the following 5 buffer spaces */
    float   *lastPhase; /* [PVDATASIZE]	Keep track of cum. phase */
    float   *fftBuf;	/* [PVFFTSIZE]	FFT works on Real & Imag */
    float   *dsBuf;	/* [PVFFTSIZE]	Output of downsampling may be 2x */
    float   *outBuf;	/* [PVFFTSIZE]	Output buffer over win length */
    float   *window;	/* [PVWINLEN]	Store 1/2 window */
    PVBUFREAD *pvbufread;

} PVCROSS;



extern void pvbufreadset (PVBUFREAD *p);
extern void pvbufread (PVBUFREAD *p);
extern void pvinterpset (PVINTERP *p);
extern void pvinterp (PVINTERP *p);
extern void pvcrossset (PVCROSS *p);
extern void pvcross (PVCROSS *p);


#endif __pvinterp_h__

