#ifndef __pvadd_h__
#define __pvadd_h__


/*      					 	PVADD.H    */

#define     MAXBINS	    4096
#ifndef PVFRAMSIZE
#define     PVFRAMSIZE	    8192		/* i.e. max FFT point size */
#endif
#define     PVFFTSIZE	    (2*PVFRAMSIZE)	/* 2x for real + imag */
#define     pvfrsiz(p)	    (p->frSiz)

typedef struct {
    OPDS    h;
    float   *rslt, *ktimpnt, *kfmod, *ifilno, *ifn, *ibins;
    float   *ibinoffset, *ibinincr, *imode, *ifreqlim, *igatefun;
    MEMFIL  *mfp;
    FUNC *ftp, *AmpGateFunc;
    AUXCH   auxch;
    float   *oscphase, *buf, *pvcopy, PvMaxAmp;
    float   frPktim, frPrtim, *frPtr, asr;
    long    maxFr, frSiz, prFlg, mems;
    int     maxbin;
} PVADD;




extern void FetchInForAdd (float *inp, float *buf, long int fsize, float pos, int binoffset, int maxbin, int binincr);
extern void pvaddset (PVADD *p);
extern void pvadd (PVADD *p);


#endif __pvadd_h__

