#include <stdio.h>

#include "cs.h"
#include "entry.h"
#include "one_zero.h"

/*******************************************/
/*  One Zero Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */
/*  The parameter gain is an additional    */
/*  gain parameter applied to the filter   */
/*  on top of the normalization that takes */
/*  place automatically.  So the net max   */
/*  gain through the system equals the     */
/*  value of gain.  sgain is the combina-  */
/*  tion of gain and the normalization     */
/*  parameter, so if you set the poleCoeff */
/*  to alpha, sgain is always set to       */
/*  gain / (1.0 - fabs(alpha)).            */
/*******************************************/

void
make_OneZero(OneZero * z)
{
	z->gain = 1.0f;
	z->zeroCoeff = 1.0f;
	z->sgain = 0.5f;
	z->inputs = 0.0f;
	z->lastOutput = 0.0f;
}

float
OneZero_tick(OneZero * z, float sample)
{				/*   Perform Filter Operation  */
	float temp;
	temp = z->sgain * sample;
	z->lastOutput = (z->inputs * z->zeroCoeff) + temp;
	z->inputs = temp;
	return z->lastOutput;
}

void
OneZero_setCoeff(OneZero * z, float aValue)
{
/*     info << "setCoeff=" << aValue << "\n" << endmsg;
 */
	z->zeroCoeff = aValue;
	if (z->zeroCoeff > 0.0f)	/*  Normalize gain to 1.0 max  */
		z->sgain = z->gain / (1.0f + z->zeroCoeff);
	else
		z->sgain = z->gain / (1.0f - z->zeroCoeff);
}

void
OneZero_print(OneZero * p)
{
	info << "OneZero: gain=" << p->gain << " inputs=" << p->inputs << " zeroCoeff=" << p->zeroCoeff << " sgain=" << p->sgain << " last=" << p->lastOutput << "\n" << endmsg;

}
