#ifndef __moog1_h__
#define __moog1_h__


/******************************************/
/*  Moog1 Subclass of                     */                   
/*  Sampling Synthesizer Class            */
/*  by Perry R. Cook, 1995-96             */ 
/*                                        */
/*   Controls:    CONTROL1 = filterQ      */
/*                CONTROL2 = filterRate   */
/*		  CONTROL3 = vibFreq      */
/*		  MOD_WHEEL= vibAmt       */
/******************************************/

#if !defined(__Moog1_h)
#define __Moog1_h

#include "fm4op.h"

/*******************************************/
/*  Sweepable Formant (2-pole)             */
/*  Filter Class, by Perry R. Cook, 1995-96*/ 
/*  See books on filters to understand     */
/*  more about how this works.  Nothing    */
/*  out of the ordinary in this version.   */
/*******************************************/

typedef struct FormSwep {
    float	gain;
    float	outputs[2];
    float	poleCoeffs[2];
    float	freq;
    float	reson;
    int		dirty;
    float	targetFreq;
    float	targetReson;
    float	targetGain;
    float	currentFreq;
    float	currentReson;
    float	currentGain;
    float	deltaFreq;
    float	deltaReson;
    float	deltaGain;
    float	sweepState;
    float	sweepRate;
} FormSwep;

void make_FormSwep(FormSwep *);
#define FormSwep_setSweepRate(p,aRate)	(p.sweepRate = aRate)
#define FormSwep_clear(p)		(p.outputs[0]=p.outputs[1]=0.0f)
void FormSwep_setTargets(FormSwep *, float, float, float);
float FormSwep_tick(FormSwep *, float);

typedef struct Wave {
    FUNC        *wave;
    float	rate;
    float	time;
    float	phase;
} Wave;

/*******************************************/
/*  Master Class for Sampling Synthesizer  */
/*  by Perry R. Cook, 1995-96              */ 
/*  This module contains up to 5       */
/*  attack waves, 5 looped waves, and      */
/*  an ADSR envelope.                      */
/*******************************************/

typedef struct MOOG1 {
    OPDS        h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*filterQ, *filterRate, *vibf, *vibAmt;
    float	*iatt, *ifn, *ivfn;

    ADSR        adsr; 
    Wave	attk;      /* Not looped */
    Wave        loop;      /* Looped */
    Wave	vibr;      /* Looped */
    OnePole     filter;
    float	baseFreq;
    float	attackRatio;
    float	loopRatio;
    float	attackGain;
    float	loopGain;
    float	oldfilterQ;
    float	oldfilterRate;
    FormSwep	filters[2];
    TwoZero	twozeroes[2];
} MOOG1;

#endif




extern void make_TwoZero (TwoZero *);
extern void TwoZero_setZeroCoeffs (TwoZero *, float *);
extern float TwoZero_tick (TwoZero *, float);
extern void make_FormSwep (FormSwep *p);
extern void FormSwep_setStates (FormSwep *p, float aFreq, float aReson, float aGain);
extern void FormSwep_setTargets (FormSwep *p, float aFreq, float aReson, float aGain);
extern float FormSwep_tick (FormSwep *p, float sample);
extern float Samp_tick (Wave *p);
extern void Moog1set (MOOG1 *p);
extern void Moog1 (MOOG1 *p);


#endif __moog1_h__

