#ifndef __mandolin_h__
#define __mandolin_h__


/**********************************************************************/  
/*  Commuted Mandolin Subclass of enhanced dual plucked-string model  */
/*  by Perry Cook, 1995-96                                            */
/*   Controls:	bodySize    pluckPosition	loopGain    deTuning  */
/*                                          			      */
/*  Note: Commuted Synthesis, as with many other WaveGuide techniques,*/
/*  is covered by patents, granted, pending, and/or applied-for.  All */
/*  are assigned to the Board of Trustees, Stanford University.       */
/*  For information, contact the Office of Technology Licensing,      */
/*  Stanford U.                                                       */
/**********************************************************************/  

#if !defined(__Mandolin_h)
#define __Mandolin_h
#include "clarinet.h"
#include "brass.h"

typedef struct Mandolin {
    OPDS	h;
    float	*ar;                  /* Output */
    float	*amp;
    float	*frequency;
    float	*pluckPos;
    float	*detuning;
    float	*baseLoopGain;
    float	*s_rate;
    float	*ifn;
    float	*lowestFreq;

    FUNC	*soundfile;
    float	s_time;
    float	s_lastOutput;
    DLineA	delayLine1;
    DLineA	delayLine2;
    DLineL	combDelay;
    OneZero	filter1;
    OneZero	filter2;
    long	length;
    float	lastFreq;
    float	lastLength;
    long	dampTime;
    int		waveDone;
    int		kloop;
} MANDOL;

#endif



extern void mandolinset (MANDOL *p);
extern void mandolin (MANDOL *p);


#endif __mandolin_h__

