#ifndef __fm4op_h__
#define __fm4op_h__


/*******************************************/
/*  Master Class for 4 Operator FM Synth   */
/*  by Perry R. Cook, 1995-96              */ 
/*  This module contains an 4 waves,   */
/*  4 envelopes, and various state vars.   */
/*                                         */
/*  The basic Chowning/Stanford FM patent  */
/*  expired April 1995, but there exist    */
/*  follow-on patents, mostly assigned to  */
/*  Yamaha.  If you are of the type who    */
/*  should worry about this (making money) */
/*  worry away.                            */
/*                                         */
/*******************************************/

#if !defined(__FM4OP_h)
#define __FM4OP_h

#include "physutil.h"

/*******************************************/
/*  Two Zero Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */ 
/*  See books on filters to understand     */
/*  more about how this works.  Nothing    */
/*  out of the ordinary in this version.   */
/*******************************************/

typedef struct TwoZero {
    float gain;
    float inputs[2];
    float lastOutput;
    float zeroCoeffs[2];
} TwoZero;

/*******************************************/
/*  Two Pole Filter Class,                 */
/*  by Perry R. Cook, 1995-96              */ 
/*  See books on filters to understand     */
/*  more about how this works.  Nothing    */
/*  out of the ordinary in this version.   */
/*******************************************/

typedef struct TwoPole {
    float gain;
    float onputs[2];
    float lastOutput;
    float poleCoeffs[2];
} TwoPole;

/* ********************************************************************** */

typedef struct FM4OP {
    OPDS    h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*control1, *control2, *modDepth; /* Control1 doubles as vowel */
    float	*vibFreq;
    float	*ifn0, *ifn1, *ifn2, *ifn3, *vifn;

    ADSR	adsr[4]; 
    FUNC	*waves[4];
    float	w_rate[4];         /* Parameters for vibrato */
    float	w_time[4];
    float	w_phase[4];
    FUNC	*vibWave;
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;
/*     float	v_phaseOffset; */
    TwoZero	twozero;
    float	baseFreq;
    float	ratios[4];
    float	gains[4];
} FM4OP;

typedef struct FM4OPV {
    OPDS    h;
    float	*ar;                  /* Output */
    float	*amp, *frequency;
    float	*control1, *control2, *modDepth; /* Control1 doubles as vowel */
    float	*vibFreq;
    float	*ifn0, *ifn1, *ifn2, *ifn3, *vifn;

    ADSR	adsr[4]; 
    FUNC	*waves[4];
    float	w_rate[4];
    float	w_time[4];
    float	w_phase[4];
    FUNC	*vibWave;
    float	v_rate;         /* Parameters for vibrato */
    float	v_time;         /* Parameters for vibrato */
/*     float	v_phaseOffset; */
    TwoZero	twozero;
    float	baseFreq;
    float	ratios[4];
    float	gains[4];
    float	tilt[3];
    float	mods[3];
    float	last_control;
} FM4OPV;


#endif



extern void make_TwoZero (TwoZero *p);
extern void TwoZero_setZeroCoeffs (TwoZero *p, float *coeffs);
extern float TwoZero_tick (TwoZero *p, float sample);
extern float Wave_tick (float *vTime, int len, float *data, float rate, float phase);
extern void build_FM (void);
extern void make_FM4Op (FM4OP *p);
extern void FM4Op_loadWaves (FM4OP *p);
extern void FM4Op_setRatio (FM4OP *p, int whichOne, float ratio);
extern void FM4Op_keyOff (FM4OP *p);
extern float FM4Alg5_tick (FM4OP *p, float c1, float c2);
extern void tubebellset (FM4OP *p);
extern void tubebell (FM4OP *p);
extern void rhodeset (FM4OP *p);
extern void wurleyset (FM4OP *p);
extern void wurley (FM4OP *p);
extern float FM4Alg3_tick (FM4OP *p, float c1, float c2);
extern void heavymetset (FM4OP *p);
extern void heavymet (FM4OP *p);
extern float FM4Alg8_tick (FM4OP *p, float c1, float c2);
extern void b3set (FM4OP *p);
extern void hammondB3 (FM4OP *p);
extern float FM4Alg6_tick (FM4OPV *q);
extern void FMVoices_setFreq (FM4OPV *q, float frequency);
extern void FMVoiceset (FM4OPV *q);
extern void FMVoice (FM4OPV *q);
extern float FM4Alg4_tick (FM4OP *p, float c1, float c2);
extern void percfluteset (FM4OP *p);
extern void percflute (FM4OP *p);


#endif __fm4op_h__

