/* Physical Modeling Opcodes by Gabriel Maldonado */

#include <math.h>

#include "cs.h"
#include "entry.h"
#include "auxfd.h"
#include "physGab.h"
#include "vdelay.h"

#define MAXDELAY	.2	/* 5 Hz */
unsigned long maxd;		/* max delay samples */
unsigned long maxdM1;		/* max delay samples - 1 */

void
phys1set(PHIS1 * p)
{
/*---------------- delay -----------------------*/
	auxalloc((maxd = (unsigned long) (MAXDELAY * esr)) * sizeof (float),
		 &p->aux);
	maxdM1 = maxd - 1;
	p->left = 0;
/*---------------- filter -----------------------*/
	p->c1 = p->prvhp = 0;
	p->c2 = 1;
	p->yt1 = 0;
}

void
phys1(PHIS1 * p)
{
/*---------------- delay -----------------------*/
	unsigned long indx;
	float *out = p->ar;	/* assign object data to local variables  
				 */
	float *in = p->asig;
	register float *buf = (float *) p->aux.auxp;
	register float freq_del = (1 / *p->xdel) * esr;
	register float feedback = *p->kfeedback;
	register float fv1, fv2, out_delay, bufv1;
	register long v1;
/*---------------- filter -----------------------*/
	register float c1, c2, *yt1;
	int nsmps = ksmps;

/*---------------- delay -----------------------*/
	indx = p->left;
/*---------------- filter -----------------------*/
	if (*p->filt_khp != p->prvhp) {
		float b;
		p->prvhp = *p->filt_khp;
		b = (float) (2. - cos((double) (*p->filt_khp * tpidsr)));
		p->c2 = (float) (b - sqrt((double) (b * b - 1.)));
		p->c1 = 1.0f - p->c2;
	}
	c1 = p->c1;
	c2 = p->c2;
	yt1 = &(p->yt1);
	do {
/*---------------- delay -----------------------*/
		buf[indx] = *in++ + (*yt1 * feedback);
		fv1 = indx - freq_del;	/* Make sure inside the buffer    
					 */
		while (fv1 < 0)
			fv1 += maxd;
		fv2 = (fv1 < maxdM1) ? fv1 + 1 : 0;	/* Find next sample
							   for interpolation       */
		bufv1 = buf[v1 = (long) fv1];
		out_delay = bufv1 + (fv1 - v1) * (buf[(long) fv2] - bufv1);
		if (++indx == maxd)
			indx = 0;	/* Advance current pointer */
/*---------------- filter -----------------------*/
		*out++ = *yt1 = c1 * out_delay + c2 * *yt1;
	} while (--nsmps);
	p->left = indx;
}


void
phys2set(PHIS2 * p)
{
/*---------------- delay1 -----------------------*/
	auxalloc((maxd = (unsigned long) (MAXDELAY * esr)) * sizeof (float),
		 &p->aux1);
	p->left1 = 0;
	maxdM1 = maxd - 1;
/*---------------- delay2 -----------------------*/
	auxalloc(maxd * sizeof (float), &p->aux2);
	p->left2 = 0;
/*---------------- filter1 -----------------------*/
	p->c1_1 = p->prvhp1 = 0;
	p->c2_1 = 1;
	p->yt1_1 = 0;
/*---------------- filter2 -----------------------*/
	p->c1_2 = p->prvhp2 = 0;
	p->c2_2 = 1;
	p->yt1_2 = 0;

	p->old_out = 0;

}

void
phys2(PHIS2 * p)
{
	float *out = p->ar;
	float *in = p->asig;
	int nsmps = ksmps;
	register float out1, out2, *old_out = &(p->old_out);

/*---------------- delay1 -----------------------*/
	unsigned long indx1;
	register float *buf1 = (float *) p->aux1.auxp;
	register float freq_del1 = (1 / *p->xdel1) * esr;
	register float feedback1 = *p->kfeedback1;
	register float fv1_1, fv2_1, out_delay1;
	register long v1_1;
/*---------------- filter1 -----------------------*/
	register float c1_1, c2_1, *yt1_1;
/*---------------- delay2 -----------------------*/
	unsigned long indx2;
	register float *buf2 = (float *) p->aux2.auxp;
	register float freq_del2 = (1 / *p->xdel2) * esr;
	register float feedback2 = *p->kfeedback2;
	register float fv1_2, fv2_2, out_delay2;
	register long v1_2;
/*---------------- filter2 -----------------------*/
	register float c1_2, c2_2, *yt1_2;
/*-----------------------------------------------*/


	indx1 = p->left1;
	indx2 = p->left2;
	if (*p->filt_khp1 != p->prvhp1) {
		float b;
		p->prvhp1 = *p->filt_khp1;
		b = (float) (2. - cos((double) (*p->filt_khp1 * tpidsr)));
		p->c2_1 = (float) (b - sqrt((double) (b * b - 1.)));
		p->c1_1 = 1.0f - p->c2_1;
	}
	if (*p->filt_khp2 != p->prvhp2) {
		float b;
		p->prvhp2 = *p->filt_khp2;
		b = (float) (2. - cos((double) (*p->filt_khp2 * tpidsr)));
		p->c2_2 = (float) (b - sqrt((double) (b * b - 1.)));
		p->c1_2 = 1.0f - p->c2_2;
	}
	c1_1 = p->c1_1;
	c2_1 = p->c2_1;
	c1_2 = p->c1_2;
	c2_2 = p->c2_2;
	yt1_1 = &(p->yt1_1);
	yt1_2 = &(p->yt1_2);

	do {
		buf1[indx1] = buf2[indx2] = *in++ + (*old_out * feedback1) +
		    (*old_out * feedback2);
		fv1_1 = indx1 - freq_del1;	/*Make sure inside the buffer 
						 */
		fv1_2 = indx2 - freq_del2;	/* Make sure inside the
						   buffer     */
		while (fv1_1 < 0)
			fv1_1 += maxd;
		while (fv1_2 < 0)
			fv1_2 += maxd;
		fv2_1 = (fv1_1 < maxdM1) ? fv1_1 + 1 : 0;	/*Find next
								   sample for interpolation      */
		fv2_2 = (fv1_2 < maxdM1) ? fv1_2 + 1 : 0;	/*Find next
								   sample for interpolation      */
		v1_1 = (long) fv1_1;
		v1_2 = (long) fv1_2;
		out_delay1 = buf1[v1_1] + (fv1_1 - v1_1) * (buf1[(long) fv2_1]
							    - buf1[v1_1]);
		out_delay2 = buf2[v1_2] + (fv1_2 - v1_2) * (buf2[(long) fv2_2]
							    - buf2[v1_2]);
		if (++indx1 == maxd)
			indx1 = 0;	/* Advance current pointer */
		if (++indx2 == maxd)
			indx2 = 0;	/* Advance current pointer */
		out1 = *yt1_1 = c1_1 * out_delay1 + c2_1 * *yt1_1;
		out2 = *yt1_2 = c1_2 * out_delay2 + c2_2 * *yt1_2;
		*out++ = *old_out = out1 + out2;
	} while (--nsmps);
	p->left1 = indx1;
	p->left2 = indx2;
}
OENTRY opcodes[] =
{
      {"physic1", S(PHIS1), 5, "a", "akkk", F(phys1set), NULL, F(phys1)},
   {"physic2", S(PHIS2), 5, "a", "akkkkkk", F(phys2set), NULL, F(phys2)},
	{NULL}
};
