#ifndef __hrtferX_h__
#define __hrtferX_h__

#include "3Dug.h"

typedef struct {
  OPDS 	h;
  float		*aLeft, *aRight, *aIn, *kAz, *kElev, *ifilno;   /* outputs and inputs */
  MEMFIL	*mfp;      /* file pointer */
  short		*fpbegin;
  int		oldel_index, oldaz_index;
  long		incount, outfront, outend, outcount;
  AUXCH		auxch;      /* will point to allocated memory */
  HRTF_DATUM	hrtf_data, oldhrtf_data;  /* matrix to store HRTF data */
  float		outl[BUF_LEN], outr[BUF_LEN];
  float		x[BUF_LEN], yl[BUF_LEN], yr[BUF_LEN];
  float		bl[FILT_LENm1], br[FILT_LENm1];
  float		rampup[FILT_LEN], rampdown[FILT_LEN];
} HRTFER;

extern void cfft (float *, int, int);
extern void bitreverse (float *, int);
extern void rfft (float *, int, int);
extern void cmult (float *, float *, float *, int);
extern void hrtferxkSet (HRTFER *p);
extern void hrtferxk (HRTFER *p);
extern void cfft (float *x, int NC, int forward);
extern void bitreverse (float *x, int N);
extern void rfft (float *x, int N, int forward);
extern void cmult (float *c, float *a, float *b, int n);


#endif __hrtferX_h__

