/*******************************************/
/*  DC Blocking Filter                     */
/*  by Perry R. Cook, 1995-96              */
/*  This guy is very helpful in, uh,       */
/*  blocking DC.  Needed because a simple  */
/*  low-pass reflection filter allows DC   */
/*  to build up inside recursive           */
/*  structures.                            */
/*******************************************/

#include "cs.h"
#include "entry.h"
#include "dcblockr.h"

void
dcblockrset(DCBlocker * p)
{
	p->outputs = 0.0f;
	p->inputs = 0.0f;
	p->gain = *p->gg;
	if (p->gain == 0.0f)
		p->gain = 0.99f;
}

void
dcblockr(DCBlocker * p)
{
	float *ar = p->ar;
	int nsmps = ksmps;
	float gain = p->gain;
	float outputs = p->outputs;
	float inputs = p->inputs;
	float *samp = p->in;

	do {
		float sample = *samp++;
		outputs = sample - inputs + (gain * outputs);
		inputs = sample;
		*ar++ = outputs;
	} while (--nsmps);
	p->outputs = outputs;
	p->inputs = inputs;
}




OENTRY opcodes[] =
{
	{"dcblock", S(DCBlocker), 5, "a", "ao", F(dcblockrset), NULL,
	 F(dcblockr)},
	{NULL}
};
