/* oscillator opcodes by Gabriel Maldonado */
#include "cs.h"
#include "entry.h"
#include "fgens.h"
#include "Gab_osc.h"

void
posc_set(POSC * p)
{
	FUNC *ftp;

	if ((ftp = ftnp2find(p->ift)) == NULL)
		return;
	p->ftp = ftp;
	p->tablen = ftp->flen;
	p->phs = *p->iphs * p->tablen;


}

void
posc(POSC * p)
{
	register float *out = p->out, *ft = p->ftp->ftable;
	register float *curr_samp, fract;
	register double *phs = &p->phs, si = *p->freq * p->tablen / esr;
	register long n = ksmps;


	do {
		curr_samp = ft + (long) *phs;
		fract = (float) (*phs - (long) *phs);
		*out++ = *p->amp * (*curr_samp + (*(curr_samp + 1) -
						  *curr_samp) * fract);
		if ((*phs += si) >= p->tablen)
			*phs -= p->tablen;
	} while (--n);
}


void
kposc(POSC * p)
{
	double *phs = &p->phs;
	double si = *p->freq * p->tablen / ekr;
	float *curr_samp = p->ftp->ftable + (long) *phs;
	float fract = (float) (*phs - (long) *phs);

	*p->out = *p->amp * (*curr_samp + (*(curr_samp + 1) - *curr_samp) *
			     fract);
	if ((*phs += si) >= p->tablen)
		*phs -= p->tablen;
}

void
lposc_set(LPOSC * p)
{
	FUNC *ftp;

	if ((ftp = ftnp2find(p->ift)) == NULL)
		return;
	if (!(p->fsr = ftp->gen01args.sample_rate)) {
		info << "losc: no sample rate stored in function assuming=sr\n" << endmsg;

		p->fsr = esr;
	}
	p->ftp = ftp;
	p->tablen = ftp->flen;
	p->phs = *p->iphs * p->tablen;
}


void
lposc(LPOSC * p)
{
	register float *out = p->out, *ft = p->ftp->ftable;
	register float *curr_samp, fract;
	register double *phs = &p->phs, si = *p->freq * (p->fsr / esr);
	register long n = ksmps;
	double loop, end, looplength = p->looplength;

	if ((loop = *p->kloop) < 0)
		loop = 0;
	if ((end = *p->kend) > p->tablen || end <= 0)
		end = p->tablen;
	looplength = end - loop;

	do {
		curr_samp = ft + (long) *phs;
		fract = (float) (*phs - (long) *phs);
		*out++ = *p->amp * (*curr_samp + (*(curr_samp + 1) -
						  *curr_samp) * fract);
		if ((*phs += si) >= end)
			*phs -= looplength;
	} while (--n);
}

void
lposcint(LPOSC * p)
{

	register double *phs = &p->phs;
	register double si = *p->freq * (p->fsr / esr);
	register float *out = p->out;
	register short *ft = (short *) p->ftp->ftable, *curr_samp;
	register float fract;
	register long n = ksmps;
	double loop, end, looplength = p->looplength;

	if ((loop = *p->kloop) < 0)
		loop = 0;
	if ((end = *p->kend) > p->tablen || end <= 0)
		end = p->tablen;
	looplength = end - loop;

	do {
		curr_samp = ft + (long) *phs;
		fract = (float) (*phs - (long) *phs);
		*out++ = *p->amp * (*curr_samp + (*(curr_samp + 1) -
						  *curr_samp) * fract);
		if ((*phs += si) >= end)
			*phs -= looplength;
	} while (--n);
}




OENTRY opcodes[] =
{
     {"lposc", S(LPOSC), 5, "a", "kkkkio", F(lposc_set), NULL, F(lposc)},
{"lposcint", S(LPOSC), 5, "a", "kkkkio", F(lposc_set), NULL, F(lposcint)},
	{"posc", S(POSC), 7, "s", "kkio", F(posc_set), F(kposc), F(posc)},
	{NULL}
};
