/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: ugens6.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __ugens6_h__
#define __ugens6_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>
#include <quasimodo/function_tables.h>

OpcodeArgument(DOWNSAMP)
	Number	*kr, *asig, *ilen;
	size_t	len;
};

OpcodeArgument(UPSAMP)
	Number	*ar, *ksig;
};

OpcodeArgument(INDIFF)
	Number	*rslt, *xsig, *istor;
	Number	prev;
};

OpcodeArgument(SAMPHOLD)
	Number	*xr, *xsig, *xgate, *ival, *istor;
	Number	state;
	int	audiogate;
};

OpcodeArgument(DELAY)
	Number	*ar, *asig, *idlt, *istor;
	Number	*curp;
	size_t	npts;
	AUXCH	auxch;
};

OpcodeArgument(DELAYR)
	Number	*ar, *idlt, *istor;
	Number	*curp;
	size_t	npts;
	AUXCH	auxch;
};

OpcodeArgument(DELTAP)
	Number	*ar, *xdlt;
	DELAYR	*delayr;
};

OpcodeArgument(DELAYW)
	Number	*asig;
	DELAYR	*delayr;
};

OpcodeArgument(DELAY1)
	Number	*ar, *asig, *istor;
	Number	sav1;
};

OpcodeArgument(COMB)
	Number	*ar, *asig, *krvt, *ilpt, *istor;
	Number	coef, prvt, *pntr;
	AUXCH	auxch;
};

OpcodeArgument(REVERB)
	Number	*ar, *asig, *krvt, *istor;
	Number	c1, c2, c3, c4, c5, c6, prvt;
	Number	*p1, *p2, *p3, *p4, *p5, *p6;
	Number	*adr1, *adr2, *adr3, *adr4, *adr5, *adr6;
	AUXCH	auxch;
};

OpcodeArgument(PAN)
	Number	*r1, *r2, *r3, *r4, *asig, *kx, *ky, *ifn, *imode, *ioffset;
	Number	xmul;
	int32	xoff;
	RCPointer<FunctionTable> ftp;
};



extern void downset (DOWNSAMP *p);
extern void downsamp (DOWNSAMP *p);
extern void upsamp (UPSAMP *p);
extern void indfset (INDIFF *p);
extern void interp (INDIFF *p);
extern void kntegrate (INDIFF *p);
extern void integrate (INDIFF *p);
extern void kdiff (INDIFF *p);
extern void diff (INDIFF *p);
extern void samphset (SAMPHOLD *p);
extern void ksmphold (SAMPHOLD *p);
extern void samphold (SAMPHOLD *p);
extern void delset (DELAY *p);
extern void delrset (DELAYR *p);
extern void delwset (DELAYW *p);
extern void tapset (DELTAP *p);
extern void delay (DELAY *p);
extern void delayr (DELAYR *p);
extern void delayw (DELAYW *p);
extern void deltap (DELTAP *p);
extern void deltapi (DELTAP *p);
extern void del1set (DELAY1 *p);
extern void delay1 (DELAY1 *p);
extern void cmbset (COMB *p);
extern void comb (COMB *p);
extern void alpass (COMB *p);
extern void reverbinit (void);
extern void rvbset (REVERB *p);
extern void reverb (REVERB *p);
extern void panset (PAN *p);
extern void pan (PAN *p);

#define UGENS6_OPCODE_LIST \
{"downsamp", S(DOWNSAMP), InitTime|EventTime, "k", "ao", \
	 F(downset), F(downsamp)}, \
{"upsamp", S(UPSAMP), AudioTime, "a", "k", NULL, NULL, F(upsamp)}, \
{"interp", S(INDIFF), InitTime|AudioTime, "a", "ko", \
	 F(indfset), NULL, F(interp)}, \
{"integ", S(INDIFF), InitTime|AudioTime|EventTime, "s", "xo", \
	 F(indfset), F(kntegrate), F(integrate)}, \
{"diff", S(INDIFF), InitTime|AudioTime|EventTime, "s", "xo", \
	 F(indfset), F(kdiff), F(diff)}, \
{"samphold", S(SAMPHOLD), InitTime|AudioTime|EventTime, "s", "xxoo", \
	 F(samphset), F(ksmphold), F(samphold)}, \
{"delay", S(DELAY), InitTime|AudioTime, "a", "aio", \
	 F(delset), NULL, F(delay)}, \
{"delayr", S(DELAYR), InitTime|AudioTime, "a", "io", \
	 F(delrset), NULL, F(delayr)}, \
{"delayw", S(DELAYW), InitTime|AudioTime, "", "a", \
	 F(delwset), NULL, F(delayw)}, \
{"delay1", S(DELAY1), InitTime|AudioTime, "a", "ao", \
	 F(del1set), NULL, F(delay1)}, \
{"deltap", S(DELTAP), InitTime|AudioTime, "a", "k", \
	 F(tapset), NULL, F(deltap)}, \
{"deltapi", S(DELTAP), InitTime|AudioTime, "a", "x", \
	 F(tapset), NULL, F(deltapi)}, \
{"comb", S(COMB), InitTime|AudioTime, "a", "akio", \
	 F(cmbset), NULL, F(comb)}, \
{"alpass", S(COMB), InitTime|AudioTime, "a", "akio", \
	 F(cmbset), NULL, F(alpass)}, \
{"reverb", S(REVERB), InitTime|AudioTime, "a", "ako", \
	 F(rvbset), NULL, F(reverb)}, \
{"pan", S(PAN), InitTime|AudioTime, "aaaa", "akkioo", \
	 F(panset), NULL, F(pan)}
	
	
#endif __ugens6_h__

