/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: ugens4.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __ugens4_h__
#define __ugens4_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>
#include <quasimodo/function_tables.h>

OpcodeArgument(BUZZ)
	Number	*ar, *xamp, *xcps, *knh, *ifn, *iphs;
	int16	ampcod, cpscod;
	int32	lphs;
	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(GBUZZ)
	Number	*ar, *xamp, *xcps, *kn, *kk, *kr, *ifn, *iphs;
	int16	ampcod, cpscod, prvn;
	Number	prvr, twor, rsqp1, rtn, rtnp1, rsumr;
	int32    lphs;
	RCPointer<FunctionTable>  ftp;
};

OpcodeArgument(PLUCK)
	Number	*ar, *kamp, *kcps, *icps, *ifn, *imeth, *ipar1, *ipar2;
	Number	sicps, param1, param2;
	int16	thresh1, thresh2, method;
	int32	phs256, npts, maxpts;
	AUXCH	auxch;
};

OpcodeArgument(RAND)
	Number	*ar, *xamp, *iseed;
	int16	ampcod, rand;
};

OpcodeArgument(RANDH)
	Number	*ar, *xamp, *xcps, *iseed;
	int16	ampcod, cpscod, rand;
	int32	phs;
	Number	num1;
};

OpcodeArgument(RANDI)
	Number	*ar, *xamp, *xcps, *iseed;
	int16	ampcod, cpscod, rand;
	int32	phs;
	Number	num1, num2, dfdmax;
};



extern void bzzset (BUZZ *p);
extern void buzz (BUZZ *p);
extern void gbzset (GBUZZ *p);
extern void gbuzz (GBUZZ *p);
extern void plukset (PLUCK *p);
extern void pluck (PLUCK *p);
extern void rndset (RAND *p);
extern void krand (RAND *p);
extern void arand (RAND *p);
extern void rhset (RANDH *p);
extern void krandh (RANDH *p);
extern void randh (RANDH *p);
extern void riset (RANDI *p);
extern void krandi (RANDI *p);
extern void randi (RANDI *p);

#define UGENS4_OPCODE_LIST \
{"buzz", S(BUZZ), InitTime|AudioTime, "a", "xxXXo", \
	 F(bzzset), NULL, F(buzz)}, \
{"gbuzz", S(GBUZZ), InitTime|AudioTime, "a", "xxXXXXo", \
	 F(gbzset), NULL, F(gbuzz)}, \
{"pluck", S(PLUCK), InitTime|AudioTime, "a", "XXXXXoo", \
	 F(plukset), NULL, F(pluck)}, \
{"rand", S(RAND), InitTime|EventTime|AudioTime, "s", "xv", \
	 F(rndset), F(krand), F(arand)}, \
{"randh", S(RANDH), InitTime|EventTime|AudioTime, "s", "xxv", \
	 F(rhset), F(krandh), F(randh)}, \
{"randi", S(RANDI), InitTime|EventTime|AudioTime, "s", "xxv", \
	 F(riset), F(krandi), F(randi)}
	
	
#endif __ugens4_h__

