/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: ugens2.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __qm_ugens2_h__
#define __qm_ugens2_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/function_tables.h>

OpcodeArgument(PHSOR)
	Number	*sr, *xcps, *iphs;
	Number	curphs;
};

OpcodeArgument(TABLE)
	Number	*rslt, *xndx, *xfn, *ixmode, *ixoff, *iwrap;
	Number   offset;
	int32	pfn; /* Previous function table number - used to
                        detect a change in table number when this is
                        supplied by a k rate input parameter. */
	int32   	xbmul, wrap;
	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(OSCIL1)
	Number	*rslt, *idel, *kamp, *idur, *ifn;
	int32 	kinc, phs;
	int32 	dcnt;
	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(OSCILN)
	Number   *rslt, *kamp, *ifrq, *ifn, *itimes;
	Number   index, inc, maxndx;
	int32    ntimes;
	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(OSC)
	Number	*sr, *xamp, *xcps, *ifn, *iphs;
	int32   lphs;
	RCPointer<FunctionTable> ftp;
};


extern void phsset (PHSOR *p);
extern void kphsor (PHSOR *p);
extern void phsor (PHSOR *p);
extern int itblchk (TABLE *p);
extern void ptblchk (TABLE *p);
extern void tblset (TABLE *p);
extern void tblsetkt (TABLE *p);
extern void ktable (TABLE *);
extern void ktabli (TABLE *);
extern void itable (TABLE *p);
extern void itabli (TABLE *p);
extern void ktable (TABLE *p);
extern void table (TABLE *p);
extern void ktabli (TABLE *p);
extern void tabli (TABLE *p);
extern int ftkrchk (TABLE *p);
extern void ktablekt (TABLE *p);
extern void tablekt (TABLE *p);
extern void ktablikt (TABLE *p);
extern void tablikt (TABLE *p);
extern void ko1set (OSCIL1 *p);
extern void kosc1 (OSCIL1 *p);
extern void kosc1i (OSCIL1 *p);
extern void oscnset (OSCILN *p);
extern void osciln (OSCILN *p);
extern void oscset (OSC *p);
extern void koscil (OSC *p);
extern void osckk (OSC *p);
extern void oscka (OSC *p);
extern void oscak (OSC *p);
extern void oscaa (OSC *p);
extern void koscli (OSC *p);
extern void osckki (OSC *p);
extern void osckai (OSC *p);
extern void oscaki (OSC *p);
extern void oscaai (OSC *p);

#define UGENS2_OPCODE_LIST \
{"phasor", S(PHSOR), InitTime|EventTime|AudioTime, \
	 "s", "xo", F(phsset), F(kphsor), F(phsor)}, \
{"table_i", S(TABLE), InitTime, "i", "iFooo", F(itable)}, \
{"tablei_i", S(TABLE), InitTime, "i", "iFooo", F(itabli)}, \
{"table", S(TABLE), InitTime|EventTime|AudioTime, \
	 "s", "xFooo", F(tblset), F(ktable), F(table)}, \
{"tablei", S(TABLE), InitTime|EventTime|AudioTime, \
	 "s", "xFooo", F(tblset), F(ktabli), F(tabli)}, \
{"oscil1_i", S(OSCIL1), InitTime|EventTime, \
	 "k", "iXiF", F(ko1set), F(kosc1)}, \
{"oscil1i", S(OSCIL1), InitTime|EventTime, \
	 "k", "iXiF", F(ko1set), F(kosc1i)}, \
{"osciln", S(OSCILN), InitTime|AudioTime, \
	 "a", "XiFi", F(oscnset), NULL, F(osciln)}, \
{"oscil_kk", S(OSC), InitTime|EventTime|AudioTime, \
	 "s", "xxFo", F(oscset), F(koscil), F(osckk)}, \
{"oscil_ka", S(OSC), InitTime|AudioTime, \
	 "a", "XaFo", F(oscset), NULL, F(oscka)}, \
{"oscil_ak", S(OSC), InitTime|AudioTime, \
	 "a", "aXFo", F(oscset), NULL, F(oscak)}, \
{"oscil_aa", S(OSC), InitTime|AudioTime, \
	 "a", "aaFo", F(oscset), NULL, F(oscaa)}, \
{"oscili_kk", S(OSC), InitTime|EventTime|AudioTime, \
	 "s", "XXFo", F(oscset), F(koscli), F(osckki)}, \
{"oscili_ka", S(OSC), InitTime|AudioTime, \
	 "a", "XaFo", F(oscset), NULL, F(osckai)}, \
{"oscili_ak", S(OSC), InitTime|AudioTime, \
	 "a", "aXFo", F(oscset), NULL, F(oscaki)}, \
{"oscili_aa", S(OSC), InitTime|AudioTime, \
	 "a", "aaFo", F(oscset), NULL, F(oscaai)}, \
{"oscilx", S(OSCILN), InitTime|AudioTime, \
	 "a", "XiFi", F(oscnset), NULL, F(osciln)}, \
{"tablekt", S(TABLE), InitTime|EventTime|AudioTime, \
	 "s", "xFooo", F(tblsetkt), F(ktablekt), \
	 F(tablekt)}, \
{"tableikt", S(TABLE), InitTime|EventTime|AudioTime, \
	 "s", "xFooo", F(tblsetkt), F(ktablikt), F(tablikt)}
	
	
#endif __qm_ugens2_h__

