/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: ugens1.h,v 1.2 1999/11/29 18:49:29 pbd Exp $
*/

#ifndef __qm_ugens1_h__
#define __qm_ugens1_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/function_tables.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(LINE)
	Number	*xr, *ia, *idur, *ib;
	Number	val, incr;
};

OpcodeArgument(EXPON)
	Number 	*xr, *ia, *idur, *ib;
	Number	val, mlt;
};

struct XSEG {
        int32 cnt;
        Number  val, mlt;
};

struct SEG {
        int32 cnt;
	Number  nxtpt;
};

OpcodeArgument(LINSEG)
	/* output */
	Number	*rslt;
	/* input */
	Number  *argums[VARGMAX];
        SEG	*cursegp;
	int32	nsegs;
	int32    segsrem, curcnt;
	Number   curval, curinc, curainc;
	AUXCH   auxch;
};

OpcodeArgument(EXPSEG)
	/* output */
	Number	*rslt;
	/* input */
	Number *argums[VARGMAX];
	SEG	*cursegp;
	int32    segsrem, curcnt;
	Number   curval, curmlt, curamlt;
	int32	nsegs;
	AUXCH   auxch;
};

OpcodeArgument(EXXPSEG)
	/* output */
	Number	*rslt;
	/* input */
	Number *argums[VARGMAX];
	XSEG	*cursegp;
	int32    segsrem, curcnt;
	Number   curval, curmlt, curamlt;
	int32	nsegs;
	AUXCH   auxch;
};

OpcodeArgument(LINEN)
	Number	*rslt, *sig, *iris, *idur, *idec;
	Number 	lin1, inc1, val, lin2, inc2;
	int32 	cnt1, cnt2;
};

OpcodeArgument(LINENR)
	Number	*rslt, *sig, *iris, *idec, *iatdec;
	Number 	lin1, inc1, val, val2, mlt2;
	int32 	cnt1;
};

OpcodeArgument(ENVLPX)
 	Number   *rslt, *xamp, *irise, *idur, *idec, *ifn, *iatss;
        Number   *iatdec, *ixmod;
	int32 	phs, ki, cnt1;
	Number	val, mlt1, mlt2, asym;
	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(ENVLPR)
 	Number   *rslt, *xamp, *irise, *idec, *ifn, *iatss, *iatdec;
        Number   *ixmod, *irind;
 	int32    phs, ki, rlsing, rindep;
        uint32   rlscnt;
 	Number   val, mlt1, mlt2, asym, atdec;
 	RCPointer<FunctionTable> ftp;
};

OpcodeArgument(EXPSEG2)
	Number	*rslt, *argums[VARGMAX];
	XSEG	*cursegp;
	int32	nsegs;
	AUXCH   auxch;
};			   /*gab-A1*/


extern void linset (LINE *p);
extern void kline (LINE *p);
extern void aline (LINE *p);
extern void expset (EXPON *p);
extern void kexpon (EXPON *p);
extern void expon (EXPON *p);
extern void lsgset (LINSEG *p);
extern void klnseg (LINSEG *p);
extern void linseg (LINSEG *p);
extern void adsrset (LINSEG *p);
extern void lsgrset (LINSEG *p);
extern void klnsegr (LINSEG *p);
extern void linsegr (LINSEG *p);
extern void xsgset (EXXPSEG *p);
extern void kxpseg (EXXPSEG *p);
extern void expseg (EXXPSEG *p);
extern void xsgrset (EXPSEG *p);
extern void kxpsegr (EXPSEG *p);
extern void expsegr (EXPSEG *p);
extern void lnnset (LINEN *p);
extern void klinen (LINEN *p);
extern void linen (LINEN *p);
extern void lnrset (LINENR *p);
extern void klinenr (LINENR *p);
extern void linenr (LINENR *p);
extern void evxset (ENVLPX *p);
extern void knvlpx (ENVLPX *p);
extern void envlpx (ENVLPX *p);
extern void xsgset2 (EXPSEG2 *p);
extern void expseg2 (EXPSEG2 *p);
extern void evrset (ENVLPR *p);
extern void knvlpxr (ENVLPR *p);
extern void envlpxr (ENVLPR *p);
extern void xdsrset (EXXPSEG *p);
extern void mxdsrset (EXPSEG *p);

#define UGENS1_OPCODE_LIST \
{"line", S(LINE), InitTime|EventTime|AudioTime, \
	 "s", "iii", F(linset), F(kline), F(aline)}, \
{"expon", S(EXPON), InitTime|EventTime|AudioTime, \
	 "s", "iii", F(expset), F(kexpon), F(expon)}, \
{"linseg", S(LINSEG), InitTime|EventTime|AudioTime, \
	 "s", "iin", F(lsgset), F(klnseg), F(linseg)}, \
{"linsegr", S(LINSEG), InitTime|EventTime|AudioTime, \
	 "s", "iin", F(lsgrset), F(klnsegr), F(linsegr)}, \
{"expseg", S(EXPSEG), InitTime|EventTime|AudioTime, \
	 "s", "iin", F(xsgset), F(kxpseg), F(expseg)}, \
{"expsegr", S(EXPSEG), InitTime|EventTime|AudioTime, \
	 "s", "iin", F(xsgrset), F(kxpsegr), F(expsegr)}, \
{"linen", S(LINEN), InitTime|EventTime|AudioTime, \
	 "s", "xiii", F(lnnset), F(klinen), F(linen)}, \
{"linenr", S(LINENR), InitTime|EventTime|AudioTime, \
	 "s", "xiii", F(lnrset), F(klinenr), F(linenr)}, \
{"envlpx", S(ENVLPX), InitTime|EventTime|AudioTime, \
	 "s", "xiiiiiio", F(evxset), F(knvlpx), F(envlpx)}, \
{"envlpxr", S(ENVLPR), InitTime|EventTime|AudioTime, \
	 "s", "xiiiiiooo", F(evrset), F(knvlpxr), F(envlpxr)}, \
{"aexpseg", S(EXPSEG2), InitTime|EventTime|AudioTime, \
	 "a", "iin", F(xsgset2), NULL, F(expseg2)}, \
{"adsr", S(LINSEG), InitTime|EventTime|AudioTime, \
	 "s", "iiiio", F(adsrset), F(klnseg), F(linseg)}, \
{"madsr", S(LINSEG), InitTime|EventTime|AudioTime, \
	 "s", "iiiio", F(adsrset), F(klnsegr), F(linsegr)}, \
{"xadsr", S(EXXPSEG), InitTime|EventTime|AudioTime, \
	 "s", "iiiio", F(xdsrset), F(kxpseg), F(expseg) }, \
{"mxadsr", S(EXPSEG), InitTime|EventTime|AudioTime, \
	 "s", "iiiio", F(mxdsrset), F(kxpsegr), F(expsegr) }
	
#endif __qm_ugens1_h__

