/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is int16ended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: sndwarp.h,v 1.1 1999/11/01 04:29:07 pbd Exp $
*/

#ifndef __sndwarp_h__
#define __sndwarp_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>
#include <quasimodo/function_tables.h>

struct WARPSECTION {
 	int16    cnt, wsize, flag, section;
	Number  ampincr, ampphs, offset;
};

OpcodeArgument(SNDWARP)
    Number   *r1, *r2, *xamp, *xtimewarp, *xresample, *isampfun, *ibegin,
            *iwsize, *irandw, *ioverlap, *ifn, *itimemode;
    RCPointer<FunctionTable>  ftpWind, ftpSamp;
    int32    maxFr, prFlg, flen, sampflen, nsections;
    int16    chans, *frPtr, begin;
    WARPSECTION *exp;
    AUXCH   auxch;
    int16   ampcode, timewarpcode, resamplecode;
};

OpcodeArgument(SNDWARPST)
    Number   *r1, *r2, *r3, *r4, *xamp, *xtimewarp, *xresample, 
	     *isampfun, *ibegin, *iwsize, *irandw, *ioverlap, *ifn, *itimemode;
    RCPointer<FunctionTable>    ftpWind,  ftpSamp;
    int32    maxFr, prFlg, flen, sampflen, nsections;
    int16    chans, *frPtr, begin;
    WARPSECTION *exp;
    AUXCH   auxch;
    int16   ampcode, timewarpcode, resamplecode;
};

extern void sndwarpgetset (SNDWARP *p);
extern void sndwarp (SNDWARP *p);
extern void sndwarpstgetset (SNDWARPST *p);
extern void sndwarpstset (SNDWARPST *p);
extern void sndwarpst (SNDWARPST *p);

#define SNDWARP_OPCODE_LIST \
{"sndwarp", S(SNDWARP), InitTime|EventTime, "mm", "xxxiiiiiSi", \
	 F(sndwarpgetset), NULL, F(sndwarp)}, \
{"sndwarpst", S(SNDWARPST), InitTime|EventTime, "mmmm", "xxxiiiiiSi", \
	 F(sndwarpstset), NULL, F(sndwarpst)}, \
{"sndwarp", S(SNDWARP), InitTime|EventTime, "mm", "xxxiiiiiii", \
	 F(sndwarpgetset), NULL, F(sndwarp)}, \
{"sndwarpst", S(SNDWARPST), InitTime|EventTime, "mmmm", "xxxiiiiiii", \
	 F(sndwarpstset), NULL, F(sndwarpst)}


#endif __sndwarp_h__

