/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: mathops.h,v 1.1 1999/11/01 04:29:06 pbd Exp $
*/

#ifndef __mathops_h_
#define __mathops_h_

#include <quasimodo/opcode_defs.h>

OpcodeArgument(POW)
	Number	*sr, *in, *pow, *norm;
};

OpcodeArgument(PRAND)
	Number	*out, *arg1, *arg2, *arg3;
}; 

extern void ipow (POW *p);
extern void apow (POW *p);
extern void kpow (POW *p);
extern void abuniform (PRAND *p);
extern void ikbuniform (PRAND *p);
extern void auniform (PRAND *p);
extern void ikuniform (PRAND *p);
extern void alinear (PRAND *p);
extern void iklinear (PRAND *p);
extern void atrian (PRAND *p);
extern void iktrian (PRAND *p);
extern void aexp (PRAND *p);
extern void ikexp (PRAND *p);
extern void abiexp (PRAND *p);
extern void ikbiexp (PRAND *p);
extern void agaus (PRAND *p);
extern void ikgaus (PRAND *p);
extern void acauchy (PRAND *p);
extern void ikcauchy (PRAND *p);
extern void apcauchy (PRAND *p);
extern void ikpcauchy (PRAND *p);
extern void abeta (PRAND *p);
extern void ikbeta (PRAND *p);
extern void aweib (PRAND *p);
extern void ikweib (PRAND *p);
extern void apoiss (PRAND *p);
extern void ikpoiss (PRAND *p);
extern void seedrand (PRAND *p);

#define MATHOPS_OPCODE_LIST \
{"pow_i", S(POW), InitTime, "i", "ii", F(ipow), NULL, NULL}, \
{"pow_k", S(POW), EventTime, "k", "kkp", NULL, F(kpow), NULL}, \
{"pow_a", S(POW), AudioTime, "a", "akp", NULL, NULL, F(apow)}, \
{"linrand_i", S(PRAND), InitTime, "i", "k", F(iklinear), NULL, NULL}, \
{"linrand_k", S(PRAND), EventTime, "k", "k", NULL, F(iklinear), NULL}, \
{"linrand_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(alinear)}, \
{"trirand_i", S(PRAND), InitTime, "i", "k", F(iktrian), NULL, NULL}, \
{"trirand_k", S(PRAND), EventTime, "k", "k", NULL, F(iktrian), NULL}, \
{"trirand_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(atrian)}, \
{"exprand_i", S(PRAND), InitTime, "i", "k", F(ikexp), NULL, NULL}, \
{"exprand_k", S(PRAND), EventTime, "k", "k", NULL, F(ikexp), NULL}, \
{"exprand_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(aexp)}, \
{"bexprnd_i", S(PRAND), InitTime, "i", "k", F(ikbiexp), NULL, NULL}, \
{"bexprnd_k", S(PRAND), EventTime, "k", "k", NULL, F(ikbiexp), NULL}, \
{"bexprnd_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(abiexp)}, \
{"cauchy_i", S(PRAND), InitTime, "i", "k", F(ikcauchy), NULL, NULL}, \
{"cauchy_k", S(PRAND), EventTime, "k", "k", NULL, F(ikcauchy), NULL}, \
{"cauchy_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(acauchy)}, \
{"pcauchy_i", S(PRAND), InitTime, "i", "k", F(ikpcauchy), NULL, NULL}, \
{"pcauchy_k", S(PRAND), EventTime, "k", "k", NULL, F(ikpcauchy), NULL}, \
{"pcauchy_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(apcauchy)}, \
{"poisson_i", S(PRAND), InitTime, "i", "k", F(ikpoiss), NULL, NULL}, \
{"poisson_k", S(PRAND), EventTime, "k", "k", NULL, F(ikpoiss), NULL}, \
{"poisson_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(apoiss)}, \
{"gauss_i", S(PRAND), InitTime, "i", "k", F(ikgaus), NULL, NULL}, \
{"gauss_k", S(PRAND), EventTime, "k", "k", NULL, F(ikgaus), NULL}, \
{"gauss_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(agaus)}, \
{"weibull_i", S(PRAND), InitTime, "i", "kk", F(ikweib), NULL, NULL}, \
{"weibull_k", S(PRAND), EventTime, "k", "kk", NULL, F(ikweib), NULL}, \
{"weibull_a", S(PRAND), AudioTime, "a", "kk", NULL, NULL, F(aweib)}, \
{"betarand_i", S(PRAND), InitTime, "i", "kkk", F(ikbeta), NULL, NULL}, \
{"betarand_k", S(PRAND), EventTime, "k", "kkk", NULL, F(ikbeta), NULL}, \
{"betarand_a", S(PRAND), AudioTime, "a", "kkk", NULL, NULL, F(abeta)}, \
{"unirand_i", S(PRAND), InitTime, "i", "k", F(ikuniform), NULL, NULL}, \
{"unirand_k", S(PRAND), EventTime, "k", "k", NULL, F(ikuniform), NULL}, \
{"unirand_a", S(PRAND), AudioTime, "a", "k", NULL, NULL, F(auniform)}, \
{"seed", S(PRAND), InitTime, "", "i", F(seedrand), NULL, NULL}
	

#endif __mathops_h__
