/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: lfo.h,v 1.1 1999/11/01 04:29:06 pbd Exp $
*/

#ifndef __qm_lfo_h__
#define __qm_lfo_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(LFO)
	Number   *res;
	Number   *kamp, *xcps, *type;
	AUXCH   auxd;
	Number   *sine;
	int16     lasttype;
	int32    phs;
};

extern void lfoset (LFO *);
extern void lfok   (LFO *);
extern void lfoa   (LFO *);

#define LFO_OPCODE_LIST \
{ "lfo", S(LFO), InitTime|EventTime|AudioTime,     "s",    "XXo", \
	  F(lfoset), F(lfok), F(lfoa) }


#endif __qm_lfo_h__
