/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: harmon.h,v 1.1 1999/11/17 00:45:00 pbd Exp $
*/

#ifndef __qm_harmon_h__
#define __qm_harmon_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(HARMON)
	Number   *ar, *asig, *kest, *kvar, *kfrq1, *kfrq2;
	Number	*icpsmode, *ilowest, *iptrkprd;
	int32    nbufsmps, n2bufsmps, phase1, phase2, period, autoktim, autokcnt;
	int32    mindist, maxdist, max2dist, lomaxdist, cpsmode;
	Number   c1, c2, prvq, prvest, prvar, minfrq, estprd, sicvt;
	Number   *bufp, *midp, *inp1, *inp2;
	Number   *bufq, *midq, *inq1, *inq2, *autobuf;
	Number   *puls1, *puls2, *puls3, lin1, lin2, lin3;
	Number   inc1, inc2, inc11, inc12, inc21, inc22, inc31, inc32;
	int32    cnt1, cnt2, cnt3, pnt1, pnt2, pnt3;
	int32    pnt11, pnt12, pnt13, pnt21, pnt22, pnt23, pnt31, pnt32, pnt33;
	AUXCH    auxch;
	int32    rngflg;
};

extern void harmset (HARMON *p);
extern void harmon (HARMON *p);

#define HARMON_OPCODE_LIST \
	{"harmon", S(HARMON), InitTime|AudioTime, "a", "akkkkiii", \
	      F(harmset), NULL, F(harmon)}

#endif __qm_harmon_h__
