/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: generators.h,v 1.1 1999/11/01 04:29:06 pbd Exp $
*/

#ifndef __generators_h__
#define __generators_h__

#include <quasimodo/types.h>
#include <quasimodo/function_tables.h>

typedef void  (*GeneratorFunction) (FunctionTableRequest *, FunctionTable *);

struct Generator {
	enum GeneratorType {
		/* numeric value matches Csound generator ID's */
		Unknown = 0,
		AudioFile = 1,
		Arguments = 2,
		Polynomial = 3,
		NormalizedTable = 4,
		SegmententedExponentials = 5,
		CubicPolynomial = 6,
		SegmentedStraightLines = 7,
		CubicSpline = 8,
		WeightedSumsOfSinusoids3 = 9,
		WeightedSumsOfSinusoids1 = 10,
		CosinePartials = 11,		
		LogOfBessel = 12,
		FirstKindChebysevCoefficients = 13,
		SecondKindChebysevCoefficients = 14,
		StorePolynomials = 15,
		StepFunction = 17,
		WeightedSumsOfSinusoids4 = 19,
		Windows = 20,
		RandomDistribution = 21,
		SoundFileToShort = 22,
		BreakPointSegmentedExponentials = 25,		
		BreakPointSegmentedStraightLines = 27,		
		XYTSpaceFile = 28,                        
		DataFile = 29,
		InternalVector = 30,
		MappedFile = 31,
	};

	enum GeneratorFlags {
		canDefer = 0x1,
		usesFile = 0x2
	};

        uint32 id;
	GeneratorFunction func;
        const char *name;
        GeneratorType type;
        int32 flags;
	size_t table_element_size;

	void operator ()(FunctionTableRequest *req, FunctionTable *ftp) {
		func (req, ftp);
	};

	static Generator generators[];
	static size_t generatorCount;
	static Generator *find_generator (GeneratorType);
	static Generator *find_generator (const char *);
};

extern size_t generatorCount;

#endif __generators_h__
