/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: butter.h,v 1.1 1999/11/01 04:29:06 pbd Exp $
*/

#ifndef __butter_h__
#define __butter_h__


/*		Butterworth filters coded by Paris Smaragdis 1994	*/
/*		Berklee College of Music Csound development team	*/
/*		Copyright (c) May 1994.  All rights reserved		*/

#include <quasimodo/opcode_defs.h>

OpcodeArgument(BFIL)
	Number	*sr, *ain, *kfc, *istor;
	Number	lkf;
	Number	a[8];
};

OpcodeArgument(BBFIL)
	Number	*sr, *ain, *kfo, *kbw, *istor;
	Number	lkf, lkb;
	Number	a[8];
};

extern void butter_filter (Number *, Number *, Number *);
extern void butset (BFIL *p);
extern void bbutset (BBFIL *p);
extern void hibut (BFIL *p);
extern void lobut (BFIL *p);
extern void bpbut (BBFIL *p);
extern void bcbut (BBFIL *p);
extern void butter_filter (Number *in, Number *out, Number *a);


#define BUTTER_OPCODE_LIST \
{"butterhp", S(BFIL), InitTime|EventTime, "a", "ako", \
	 F(butset), NULL, F(hibut)}, \
{"butterlp", S(BFIL), InitTime|EventTime, "a", "ako", \
	 F(butset), NULL, F(lobut)}, \
{"butterbp", S(BBFIL), InitTime|EventTime, "a", "akko", \
	 F(bbutset), NULL, F(bpbut)}, \
{"butterbr", S(BBFIL), InitTime|EventTime, "a", "akko", \
	 F(bbutset), NULL, F(bcbut)}, \
{"buthp", S(BFIL), InitTime|EventTime, "a", "ako", \
	 F(butset), NULL, F(hibut)}, \
{"butlp", S(BFIL), InitTime|EventTime, "a", "ako", \
	 F(butset), NULL, F(lobut)}, \
{"butbp", S(BBFIL), InitTime|EventTime, "a", "akko", \
	 F(bbutset), NULL, F(bpbut)}, \
{"butbr", S(BBFIL), InitTime|EventTime, "a", "akko", \
	 F(bbutset), NULL, F(bcbut)}

#endif __butter_h__

