/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holders names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to
    education and research.

    $Id: arith_ops.h,v 1.3 1999/12/17 14:52:39 pbd Exp $
*/


#ifndef __arith_ops_h__
#define __arith_ops_h__

#include <quasimodo/opcode_defs.h>

OpcodeArgument(ASSIGN)
	Number	*r, *a;
};

OpcodeArgument(RELAT)
	int	*rbool;
	Number	*a, *b;
};

OpcodeArgument(LOGCL)
	Number	*rbool, *ibool, *jbool;
};

OpcodeArgument(CONVAL)
	Number	*r;
	int	*cond;
	Number	*a, *b;
};

OpcodeArgument(MAOP)
	Number	*r, *args[8];
};

OpcodeArgument(AOP)
	Number	*r, *a, *b;
};

OpcodeArgument(DIVZ)
	Number	*r, *a, *b, *def;
};

OpcodeArgument(EVAL)
	Number	*r, *a;
};

OpcodeArgument(XENH)
	Number	*r, *pc, *et, *cy, *ref;
};

extern void initScalar (ASSIGN *);
extern void initVector (ASSIGN *);

extern void conval (CONVAL *p);
extern void aconval (CONVAL *p);
extern void int1 (EVAL *p);
extern void frac1 (EVAL *p);
extern void rnd1 (EVAL *p);
extern void birnd1 (EVAL *p);
extern void abs1 (EVAL *p);
extern void exp01 (EVAL *p);
extern void log01 (EVAL *p);
extern void sqrt1 (EVAL *p);
extern void sin1 (EVAL *p);
extern void cos1 (EVAL *p);
extern void tan1 (EVAL *p);
extern void asin1 (EVAL *p);
extern void acos1 (EVAL *p);
extern void atan1 (EVAL *p);
extern void sinh1 (EVAL *p);
extern void cosh1 (EVAL *p);
extern void tanh1 (EVAL *p);
extern void log101 (EVAL *p);
extern void atan21 (AOP *p);
extern void sqrta (EVAL *p);
extern void absa (EVAL *p);
extern void expa (EVAL *p);
extern void loga (EVAL *p);
extern void sina (EVAL *p);
extern void cosa (EVAL *p);
extern void tana (EVAL *p);
extern void asina (EVAL *p);
extern void acosa (EVAL *p);
extern void atana (EVAL *p);
extern void sinha (EVAL *p);
extern void cosha (EVAL *p);
extern void tanha (EVAL *p);
extern void log10a (EVAL *p);
extern void atan2aa (AOP *p);
extern void dbamp (EVAL *p);
extern void ampdb (EVAL *p);
extern void aampdb (EVAL *p);
extern void ftlen (EVAL *p);
extern void ftlptim (EVAL *p);
extern void numsamp (EVAL *p);
extern void ftsr (EVAL *p);
extern void ftlen2 (EVAL *p);
extern void octpch (EVAL *p);
extern void pchoct (EVAL *p);
extern void cpsoct (EVAL *p);
extern void powoftwo (EVAL *p);
extern void logbasetwo (EVAL *p);
extern void acpsoct (EVAL *p);
extern void octcps (EVAL *p);
extern void cpspch (EVAL *p);
extern void cpsxpch (XENH *p);
extern void cps2pch (XENH *p);
extern void minop (AOP *);
extern void maxop (AOP *);

#define ARITHOPS_OPCODE_LIST \
{"=_r", S(ASSIGN), InitTime, "r", "X", \
	 F(initScalar), NULL, NULL, OP_INLINED }, \
{"=_i", S(ASSIGN), InitTime, "i", "X", \
	 F(initScalar), NULL, NULL, OP_INLINED }, \
{"=_k", S(ASSIGN), InitTime|EventTime, "k", "X", \
	 F(initScalar), F(inline_AssignScalar), NULL, OP_INLINED }, \
{"=_a", S(ASSIGN), AudioTime, "a", "x", \
	 NULL, NULL, F(inline_AssignVector ), OP_INLINED}, \
{"init_i", S(ASSIGN), InitTime, "i", "i", \
	 F(initScalar), NULL, NULL }, \
{"init_i_S", S(ASSIGN), InitTime, "i", "S", \
	 F(initScalar), NULL, NULL }, \
{"init_k", S(ASSIGN), InitTime, "k", "X", \
	 F(inline_AssignScalar), NULL, NULL }, \
{"init_k_S", S(ASSIGN), InitTime, "k", "S", \
	 F(initScalar), NULL, NULL }, \
{"init_a", S(ASSIGN), InitTime, "a", "X", \
	 F(initVector), NULL, NULL }, \
{">", S(RELAT), InitTime|EventTime, "X", "XX", \
	 F(inline_GT), F(inline_GT), NULL, INFIX_OK|OP_INLINED }, \
{">=", S(RELAT), InitTime|EventTime, "X", "XX", \
	 F(inline_GTEQ), F(inline_GTEQ), NULL, INFIX_OK|OP_INLINED }, \
{"<", S(RELAT), InitTime|EventTime, "X", "XX", \
	 F(inline_LT), F(inline_LT), NULL, INFIX_OK|OP_INLINED }, \
{"<=", S(RELAT), InitTime|EventTime, "X", "XX", \
	 F(inline_LTEQ), F(inline_LTEQ), NULL, INFIX_OK|OP_INLINED }, \
{"==", S(RELAT), InitTime|EventTime, "X", "XX", \
	 F(inline_EQ), F(inline_EQ), NULL, INFIX_OK|OP_INLINED }, \
{"!=", S(RELAT), InitTime|EventTime, "X", "XX", \
	 F(inline_NOTEQ), F(inline_NOTEQ), NULL, INFIX_OK|OP_INLINED }, \
{"&&", S(LOGCL), InitTime|EventTime, "X", "XX", \
	 F(inline_LogicalAnd), F(inline_LogicalAnd), NULL, INFIX_OK|OP_INLINED},\
{"||", S(LOGCL), InitTime|EventTime, "X", "XX", \
	 F(inline_LogicalOr), F(inline_LogicalOr), NULL,INFIX_OK|OP_INLINED}, \
{":_i", S(CONVAL), InitTime, "i", "bii", \
	 F(inline_ConditionScalar), NULL, NULL, OP_INLINED }, \
{":_k", S(CONVAL), EventTime, "k", "Xkk", \
	 NULL, F(inline_ConditionScalar), NULL, OP_INLINED }, \
{":_a", S(CONVAL), AudioTime, "a", "Xxx", \
	 NULL, NULL, F(inline_ConditionVector), OP_INLINED }, \
\
{"mod_ii", S(AOP), InitTime, "i", "ii", \
	 F(inline_modScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"mod_kx", S(AOP), EventTime, "k", "XX", \
	 NULL, F(inline_modScalars), NULL, INFIX_OK|OP_INLINED }, \
{"mod_aa", S(AOP), AudioTime, "a", "aa",\
	 NULL, NULL, F(inline_modVectors), INFIX_OK|OP_INLINED }, \
{"mod_aX", S(AOP), AudioTime, "a", "aX", \
	 NULL, NULL, F(inline_modVectorScalar), INFIX_OK|OP_INLINED }, \
\
{"modeq_ii", S(ASSIGN), InitTime, "i", "i", \
	 F(inline_modeqScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"modeq_kx", S(ASSIGN), EventTime, "k", "X", \
	 NULL, F(inline_modeqScalars), NULL, INFIX_OK|OP_INLINED }, \
\
{"pow_ii", S(AOP), InitTime, "i", "ii", \
	 F(inline_powScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"pow_kx", S(AOP), EventTime, "k", "XX", \
	 NULL, F(inline_powScalars), NULL, INFIX_OK|OP_INLINED }, \
{"pow_aa", S(AOP), AudioTime, "a", "aa",\
	 NULL, NULL, F(inline_powVectors), INFIX_OK|OP_INLINED }, \
{"pow_aX", S(AOP), AudioTime, "a", "aX", \
	 NULL, NULL, F(inline_powVectorScalar), INFIX_OK|OP_INLINED }, \
\
{"add_ii", S(AOP), InitTime, "i", "ii", \
	 F(inline_addScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"add_aX", S(AOP), AudioTime, "a", "aX", \
	 NULL, NULL, F(inline_addVectorScalar), INFIX_OK|OP_INLINED }, \
{"add_aa", S(AOP), AudioTime, "a", "aa", \
	 NULL, NULL, F(inline_addVectors), INFIX_OK|OP_INLINED }, \
{"add_xx", S(AOP), EventTime, "k", "XX", \
	 NULL, F(inline_addScalars), NULL, INFIX_OK|OP_INLINED }, \
{"add_Xa", S(AOP), AudioTime, "a", "Xa", \
 	 NULL, NULL, F(inline_addScalarVector), INFIX_OK|OP_INLINED }, \
\
{"addeq_ii", S(ASSIGN), InitTime, "i", "i", \
	 F(inline_addeqScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"addeq_aX", S(ASSIGN), AudioTime, "a", "X", \
	 NULL, NULL, F(inline_addeqVectorScalar), INFIX_OK|OP_INLINED }, \
{"addeq_aa", S(ASSIGN), AudioTime, "a", "a", \
	 NULL, NULL, F(inline_addeqVectors), INFIX_OK|OP_INLINED }, \
{"addeq_xx", S(ASSIGN), EventTime, "k", "X", \
	 NULL, F(inline_addeqScalars), NULL, INFIX_OK|OP_INLINED }, \
\
{"sub_ii", S(AOP), InitTime, "i", "ii", \
	 F(inline_subScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"sub_xx", S(AOP), EventTime, "k", "XX", \
	 NULL, F(inline_subScalars), NULL, INFIX_OK|OP_INLINED }, \
{"sub_aX", S(AOP), AudioTime, "a", "aX", \
	 NULL, NULL, F(inline_subVectorScalar), INFIX_OK|OP_INLINED }, \
{"sub_aa", S(AOP), AudioTime, "a", "aa", \
	 NULL, NULL, F(inline_subVectors), INFIX_OK|OP_INLINED }, \
{"sub_Xa", S(AOP), AudioTime, "a", "Xa", \
	 NULL, NULL, F(inline_subScalarVector), INFIX_OK|OP_INLINED }, \
\
{"subeq_ii", S(ASSIGN), InitTime, "i", "i", \
	 F(inline_subeqScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"subeq_xx", S(ASSIGN), EventTime, "k", "X", \
	 NULL, F(inline_subeqScalars), NULL, INFIX_OK|OP_INLINED }, \
{"subeq_aX", S(ASSIGN), AudioTime, "a", "X", \
	 NULL, NULL, F(inline_subeqVectorScalar), INFIX_OK|OP_INLINED }, \
{"subeq_aa", S(ASSIGN), AudioTime, "a", "a", \
	 NULL, NULL, F(inline_subeqVectors), INFIX_OK|OP_INLINED }, \
\
{"mul_ii", S(AOP), InitTime, "i", "ii", \
	 F(inline_mulScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"mul_xx", S(AOP), EventTime, "k", "XX", \
	 NULL, F(inline_mulScalars), NULL, INFIX_OK|OP_INLINED }, \
{"mul_aX", S(AOP), AudioTime, "a", "aX", \
	 NULL, NULL, F(inline_mulVectorScalar), INFIX_OK|OP_INLINED }, \
{"mul_aa", S(AOP), AudioTime, "a", "aa", \
	 NULL, NULL, F(inline_mulVectors), INFIX_OK|OP_INLINED }, \
{"mul_Xa", S(AOP), AudioTime, "a", "Xa", \
 	 NULL, NULL, F(inline_mulScalarVector), INFIX_OK|OP_INLINED }, \
\
{"muleq_ii", S(ASSIGN), InitTime, "i", "i", \
	 F(inline_muleqScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"muleq_xx", S(ASSIGN), EventTime, "k", "X", \
	 NULL, F(inline_muleqScalars), NULL, INFIX_OK|OP_INLINED }, \
{"muleq_aX", S(ASSIGN), AudioTime, "a", "X", \
	 NULL, NULL, F(inline_muleqVectorScalar), INFIX_OK|OP_INLINED }, \
{"muleq_aa", S(ASSIGN), AudioTime, "a", "a", \
	 NULL, NULL, F(inline_muleqVectors), INFIX_OK|OP_INLINED }, \
\
{"div_ii", S(AOP), InitTime, "i", "ii", \
	 F(inline_divScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"div_xx", S(AOP), EventTime, "k", "XX", \
	 NULL, F(inline_divScalars), NULL, INFIX_OK|OP_INLINED }, \
{"div_aX", S(AOP), AudioTime, "a", "aX", \
	 NULL, NULL, F(inline_divVectorScalar), INFIX_OK|OP_INLINED }, \
{"div_aa", S(AOP), AudioTime, "a", "aa", \
	 NULL, NULL, F(inline_divVectors), INFIX_OK|OP_INLINED }, \
{"div_Xa", S(AOP), AudioTime, "a", "Xa", \
	 NULL, NULL, F(inline_divScalarVector), INFIX_OK|OP_INLINED }, \
\
{"diveq_ii", S(ASSIGN), InitTime, "i", "i", \
	 F(inline_diveqScalars), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"diveq_xx", S(ASSIGN), EventTime, "k", "X", \
	 NULL, F(inline_diveqScalars), NULL, INFIX_OK|OP_INLINED }, \
{"diveq_aX", S(ASSIGN), AudioTime, "a", "X", \
	 NULL, NULL, F(inline_diveqVectorScalar), INFIX_OK|OP_INLINED }, \
{"diveq_aa", S(ASSIGN), AudioTime, "a", "a", \
	 NULL, NULL, F(inline_diveqVectors), INFIX_OK|OP_INLINED }, \
\
{"usub_i",  S(AOP), InitTime, "i", "i", \
	 F(inline_usubScalar), NULL, NULL, INFIX_OK|OP_INLINED }, \
{"usub_k",  S(AOP), InitTime|EventTime, "k", "k", \
	 F(inline_usubScalar), F(inline_usubScalar), NULL, INFIX_OK|OP_INLINED }, \
{"usub_a", S(AOP), AudioTime, "a", "a", \
	 NULL, NULL, F(inline_usubVector), INFIX_OK|OP_INLINED }, \
\
{"madd_aa", S(MAOP), AudioTime, "a", "aay", \
	 NULL, NULL, F(inline_addVectorsNWay), OP_INLINED}, \
{"msub_aa", S(MAOP), AudioTime, "a", "aayyyyyy", \
	 NULL, NULL, F(inline_subVectorsNWay), OP_INLINED }, \
{"mmult_aa", S(MAOP), AudioTime, "a", "aayyyyyy", \
	 NULL, NULL, F(inline_mulVectorsNWay), OP_INLINED}, \
{"mdiv_aa", S(MAOP), AudioTime, "a", "xaayyyyyy", \
	 NULL, NULL, F(inline_divVectorsNWay), OP_INLINED }, \
\
{"madd_kk", S(MAOP), EventTime, "X", "XXzzzzzz", \
	 NULL, F(inline_addScalarsNWay), NULL, OP_INLINED }, \
{"msub_kk", S(MAOP), EventTime, "X", "XXzzzzzz", \
	 NULL, F(inline_subScalarsNWay), NULL, OP_INLINED }, \
{"mmult_kk", S(MAOP), EventTime, "X", "XXzzzzzz", \
	 NULL, F(inline_mulScalarsNWay), NULL, OP_INLINED}, \
{"mdiv_kk", S(MAOP), EventTime, "X", "XXzzzzzz", \
	 NULL, F(inline_divScalarsNWay), NULL, OP_INLINED }, \
\
{"divz_ii", S(DIVZ), InitTime, "i", "iii", \
	 F(inline_divzScalars), NULL, NULL, OP_INLINED }, \
{"divz_kk", S(DIVZ), EventTime, "k", "kkk", \
	 NULL, F(inline_divzScalars), NULL, OP_INLINED }, \
{"divz_ka", S(DIVZ), AudioTime, "a", "kak", \
	 NULL, NULL, F(inline_divzVectorScalar), OP_INLINED}, \
{"divz_aa", S(DIVZ), AudioTime, "a", "aak", \
	 NULL, NULL, F(inline_divzVectors), OP_INLINED }, \
{"divz_ak", S(DIVZ), AudioTime, "a", "akk", \
	 NULL, NULL, F(inline_divzScalarVector), OP_INLINED}, \
\
{"min", S(AOP), InitTime|EventTime, "X", "XX", \
	 F(inline_min), F(inline_min), NULL, OP_INLINED}, \
{"max", S(AOP), InitTime|EventTime, "X", "XX", \
	 F(inline_max), F(inline_max), NULL,}, \
{"int_i", S(EVAL), InitTime, "i", "i", \
	 F(int1), NULL, NULL, IS_FUNCTION}, \
{"frac_i", S(EVAL), InitTime, "i", "i", \
	 F(frac1), NULL, NULL, IS_FUNCTION}, \
{"rnd_i", S(EVAL), InitTime, "i", "i", \
	 F(rnd1), NULL, NULL, IS_FUNCTION}, \
{"birnd_i", S(EVAL), InitTime, "i", "i", \
	 F(birnd1), NULL, NULL, IS_FUNCTION}, \
{"abs_i", S(EVAL), InitTime, "i", "i", \
	 F(abs1), NULL, NULL, IS_FUNCTION}, \
{"exp_i", S(EVAL), InitTime, "i", "i", \
	 F(exp01), NULL, NULL, IS_FUNCTION}, \
{"log_i", S(EVAL), InitTime, "i", "i", \
	 F(log01), NULL, NULL, IS_FUNCTION}, \
{"sqrt_i", S(EVAL), InitTime, "i", "i", \
	 F(sqrt1), NULL, NULL, IS_FUNCTION}, \
{"sin_i", S(EVAL), InitTime, "i", "i", \
	 F(sin1), NULL, NULL, IS_FUNCTION}, \
{"cos_i", S(EVAL), InitTime, "i", "i", \
	 F(cos1), NULL, NULL, IS_FUNCTION}, \
{"tan_i", S(EVAL), InitTime, "i", "i", \
	 F(tan1), NULL, NULL, IS_FUNCTION}, \
{"sininv_i", S(EVAL), InitTime, "i", "i", \
	 F(asin1), NULL, NULL, IS_FUNCTION}, \
{"cosinv_i", S(EVAL), InitTime, "i", "i", \
	 F(acos1), NULL, NULL, IS_FUNCTION}, \
{"taninv_i", S(EVAL), InitTime, "i", "i", \
	 F(atan1), NULL, NULL, IS_FUNCTION}, \
{"taninv2_i", S(AOP), InitTime, "i", "ii", \
	 F(atan21), NULL, NULL, IS_FUNCTION}, \
{"log10_i", S(EVAL), InitTime, "i", "i", \
	 F(log101), NULL, NULL, IS_FUNCTION}, \
{"sinh_i", S(EVAL), InitTime, "i", "i", \
	 F(sinh1), NULL, NULL, IS_FUNCTION}, \
{"cosh_i", S(EVAL), InitTime, "i", "i", \
	 F(cosh1), NULL, NULL, IS_FUNCTION}, \
{"tanh_i", S(EVAL), InitTime, "i", "i", \
	 F(tanh1), NULL, NULL, IS_FUNCTION}, \
{"int_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(int1), F(int1), NULL, IS_FUNCTION}, \
{"frac_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(frac1), F(frac1), NULL, IS_FUNCTION}, \
{"rnd_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(rnd1), F(rnd1), NULL, IS_FUNCTION}, \
{"birnd_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(birnd1), F(birnd1), NULL, IS_FUNCTION}, \
{"abs_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(abs1), F(abs1), NULL, IS_FUNCTION}, \
{"exp_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(exp01), F(exp01), NULL, IS_FUNCTION}, \
{"log_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(log01), F(log01), NULL, IS_FUNCTION}, \
{"sin_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(sin1), F(sin1), NULL, IS_FUNCTION}, \
{"cos_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(cos1), F(cos1), NULL, IS_FUNCTION}, \
{"tan_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(tan1), F(tan1), NULL, IS_FUNCTION}, \
{"sininv_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(asin1), F(asin1), NULL, IS_FUNCTION}, \
{"cosinv_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(acos1), F(acos1), NULL, IS_FUNCTION}, \
{"taninv_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(atan1), F(atan1), NULL, IS_FUNCTION}, \
{"taninv2_k", S(AOP), EventTime, "k", "XX", \
	 F(atan21), F(atan21), NULL, IS_FUNCTION}, \
{"sinh_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 NULL, F(sinh1), NULL, IS_FUNCTION}, \
{"cosh_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(cosh1), F(cosh1), NULL, IS_FUNCTION}, \
{"tanh_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(tanh1), F(tanh1), NULL, IS_FUNCTION}, \
{"log10_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(log101), F(log101), NULL, IS_FUNCTION}, \
{"sqrt_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(sqrt1), F(sqrt1), NULL, IS_FUNCTION}, \
{"abs_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(absa), IS_FUNCTION}, \
{"exp_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(expa), IS_FUNCTION}, \
{"log_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(loga), IS_FUNCTION}, \
{"sin_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(sina), IS_FUNCTION}, \
{"cos_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(cosa), IS_FUNCTION}, \
{"tan_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(tana), IS_FUNCTION}, \
{"sininv_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(asina), IS_FUNCTION}, \
{"cosinv_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(acosa), IS_FUNCTION}, \
{"taninv_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(atana), IS_FUNCTION}, \
{"taninv2_a", S(AOP), AudioTime, "a", "aa", \
	 NULL, NULL, F(atan2aa), IS_FUNCTION}, \
{"sinh_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(sinha), IS_FUNCTION}, \
{"cosh_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(cosha), IS_FUNCTION}, \
{"tanh_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(tanha), IS_FUNCTION}, \
{"log10_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(log10a), IS_FUNCTION}, \
{"sqrt_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(sqrta), IS_FUNCTION}, \
{"dbamp_i", S(EVAL), InitTime, "i", "i", \
	 F(dbamp), NULL, NULL, IS_FUNCTION}, \
{"ampdb_i", S(EVAL), InitTime, "i", "i", \
	 F(ampdb), NULL, NULL, IS_FUNCTION}, \
{"dbamp_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(ampdb), F(dbamp), NULL, IS_FUNCTION}, \
{"ampdb_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(ampdb), F(ampdb), NULL, IS_FUNCTION}, \
{"ampdb_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(aampdb), IS_FUNCTION}, \
{"cpsoct_i", S(EVAL), InitTime, "i", "i", \
	 F(cpsoct), NULL, NULL, IS_FUNCTION}, \
{"octpch_i", S(EVAL), InitTime, "i", "i", \
	 F(octpch), NULL, NULL, IS_FUNCTION}, \
{"cpspch_i", S(EVAL), InitTime, "i", "i", \
	 F(cpspch), NULL, NULL, IS_FUNCTION}, \
{"pchoct_i", S(EVAL), InitTime, "i", "i", \
	 F(pchoct), NULL, NULL, IS_FUNCTION}, \
{"octcps_i", S(EVAL), InitTime, "i", "i", \
	 F(octcps), NULL, NULL, IS_FUNCTION}, \
{"cpsoct_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(cpsoct), F(cpsoct), NULL, IS_FUNCTION}, \
{"octpch_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(octpch), F(octpch), NULL, IS_FUNCTION}, \
{"cpspch_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(cpspch), F(cpspch), NULL, IS_FUNCTION}, \
{"pchoct_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(pchoct), F(pchoct), NULL, IS_FUNCTION}, \
{"octcps_k", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(octcps), F(octcps), NULL, IS_FUNCTION}, \
{"cpsoct_a", S(EVAL), AudioTime, "a", "a", \
	 NULL, NULL, F(acpsoct), IS_FUNCTION}, \
{"ftlen_i", S(EVAL), InitTime, "i", "i", \
	 F(ftlen), NULL, NULL, IS_FUNCTION}, \
{"ftlptim_i", S(EVAL), InitTime, "i", "i", \
	 F(ftlptim), NULL, NULL, IS_FUNCTION}, \
{"cpsxpch", S(XENH), InitTime, "i", "iiii", \
	 F(cpsxpch), NULL, NULL}, \
{"cps2pch", S(XENH), InitTime, "i", "ii", \
	 F(cps2pch), NULL, NULL}, \
{"iftlen2", S(EVAL), InitTime, "i", "i", \
	 F(ftlen2)}, \
{"insamp", S(EVAL), InitTime, "i", "i", \
	 F(numsamp)}, \
{"iftsr", S(EVAL), InitTime, "i", "i", \
	 F(ftsr)}, \
{"ipowoftwo", S(EVAL), InitTime, "i", "i", \
	 F(powoftwo)}, \
{"kpowoftwo", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(powoftwo), F(powoftwo)}, \
{"ilogbtwo", S(EVAL), InitTime, "i", "i", \
	 F(logbasetwo)}, \
{"klogbtwo", S(EVAL), InitTime|EventTime, "k", "X", \
	 F(logbasetwo), F(logbasetwo)}


#endif __arith_ops_h__
