/*
    Copyright (C) 1998 Gabriel Maldonado

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: wrap.h,v 1.1 1999/11/01 04:25:04 pbd Exp $
*/

#ifndef __wrap_h__
#define __wrap_h__

#include <quasimodo/opcode_defs.h>

/********************************************/
/* wrap and mirror UGs by Gabriel Maldonado */
/********************************************/

OpcodeArgument(WRAP)
    Number *xdest, *xsig, *xlow, *xhigh;
};


OpcodeArgument(TRIG)
    Number *kout, *ksig, *kthreshold, *kmode;
    Number old_sig;
};


OpcodeArgument(INTERPOL)
    Number *r, *val1, *val2, *point, *imin, *imax;
    Number point_factor;
};

extern void wrap (WRAP *p);
extern void kwrap (WRAP *p);
extern void kmirror (WRAP *p);
extern void mirror (WRAP *p);
extern void trig_set (TRIG *p);
extern void trig (TRIG *p);
extern void interpol (INTERPOL *p);
extern void nterpol_init (INTERPOL *p);
extern void knterpol (INTERPOL *p);
extern void anterpol (INTERPOL *p);

#define WRAP_OPCODE_LIST \
{"iwrap", S(WRAP), 1, "i", "iii", \
	 F(kwrap), NULL, NULL }, \
{"wrap", S(WRAP), EventTime|AudioTime, "s", "xXX", \
	 NULL, F(kwrap), F(wrap) }, \
{"imirror", S(WRAP), InitTime, "i", "iii", \
	 F(kmirror), NULL, NULL }, \
{"mirror", S(WRAP), EventTime|AudioTime, "s", "xXX", \
	 NULL, F(kmirror), F(mirror) }, \
{"trig", S(TRIG), InitTime|EventTime, "k", "XXX", \
	 F(trig_set), F(trig), NULL },\
{"intrpol", S(INTERPOL), InitTime, "i", "iiiop", \
	 F(interpol) }, \
{"kntrpol", S(INTERPOL), InitTime|EventTime, "k", "XXXop", \
	 F(nterpol_init), F(knterpol) }, \
{"antrpol", S(INTERPOL), InitTime|AudioTime, "a", "aaXop", \
	 F(nterpol_init), NULL, F(anterpol)}

#endif __wrap_h__

