/*
    Copyright (C) 1998 Gabriel Maldonado

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: wrap.cc,v 1.1 1999/11/01 04:25:04 pbd Exp $
*/

/********************************************/
/* wrap and mirror UGs by Gabriel Maldonado */
/********************************************/

#include <math.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>

#include "wrap.h"

void
wrap(WRAP * p)
{
	Number *adest = p->xdest;
	Number *asig = p->xsig;
	Number xlow, xhigh, xsig;
	int16 loopcount = ksmps;

	if ((xlow = *p->xlow) >= (xhigh = *p->xhigh)) {
		Number xaverage;
		xaverage = (xlow + xhigh) / 2;
		do
			*adest++ = xaverage;
		while (--loopcount);
	} else
		do {
			if ((xsig = (Number) *asig++) >= xlow)
				*adest++ = (Number) (xlow + fmod(xsig - xlow,
						    fabs(xlow - xhigh)));
			else
				*adest++ = (Number) (xhigh - fmod(xhigh - xsig,
						    fabs(xlow - xhigh)));
		} while (--loopcount);
}


void
kwrap(WRAP * p)
{
	Number xsig, xlow, xhigh;

	if ((xlow = *p->xlow) >= (xhigh = *p->xhigh)) {
		*p->xdest = (xlow + xhigh) / 2;
	} else {
		if ((xsig = *p->xsig) >= xlow)
			*p->xdest = (Number) (xlow + fmod(xsig - xlow, fabs(xlow
							      - xhigh)));
		else
			*p->xdest = (Number) (xhigh - fmod(xhigh - xsig,
						    fabs(xlow - xhigh)));
	}
}


/*---------------------------------------------------------------------*/


void
kmirror(WRAP * p)
{
	Number xsig, xlow, xhigh;
	xsig = *p->xsig;
	xhigh = *p->xhigh;
	xlow = *p->xlow;

	if (xlow >= xhigh)
		*p->xdest = (xlow + xhigh) / 2;
	else {
	      kw_label:
		if ((xsig <= xhigh) && (xsig >= xlow))
			*p->xdest = xsig;
		else {
			if (xsig > xhigh) {
				xsig = xhigh + xhigh - xsig;
				goto kw_label;
			} else {
				xsig = xlow + xlow - xsig;
				goto kw_label;
			}
		}
	}
}


void
mirror(WRAP * p)
{
	Number *adest, *asig;
	Number xlow, xhigh, xaverage, xsig;
	int16 loopcount = ksmps;

	adest = p->xdest;
	asig = p->xsig;
	xlow = *p->xlow;
	xhigh = *p->xhigh;

	if (xlow >= xhigh) {
		xaverage = (xlow + xhigh) / 2;
		do
			*adest++ = xaverage;
		while (--loopcount);
	}
	do {
		xsig = *asig++;
	      w_label:
		if ((xsig <= xhigh) && (xsig >= xlow))
			*adest++ = xsig;
		else {
			if (xsig > xhigh) {
				xsig = xhigh + xhigh - xsig;
				goto w_label;
			} else {
				xsig = xlow + xlow - xsig;
				goto w_label;
			}
		}
	} while (--loopcount);
}


void
trig_set(TRIG * p)
{				/* trig by G.Maldonado */
	p->old_sig = 0.0;

}

void
trig(TRIG * p)
{
	switch ((int) (*p->kmode + .5)) {
	case 0:		/* down-up */
		if (p->old_sig <= *p->kthreshold && *p->ksig > *p->kthreshold)
			*p->kout = 1.;
		else
			*p->kout = 0.;
		break;
	case 1:		/* up-down */
		if (p->old_sig >= *p->kthreshold && *p->ksig < *p->kthreshold)
			*p->kout = 1.;
		else
			*p->kout = 0.;
		break;
	case 2:		/* both */
		if ((p->old_sig <= *p->kthreshold && *p->ksig > *p->kthreshold)
		    ||
		    (p->old_sig >= *p->kthreshold && *p->ksig <
		     *p->kthreshold))
			*p->kout = 1.;
		else
			*p->kout = 0.;
		break;
	default:
		error << "PERF:  bad imode value" << endmsg;


	}
	p->old_sig = *p->ksig;
}

/*-------------------------------*/

/* interpolation opcodes by G.Maldonado */
void
interpol(INTERPOL * p)
{
	Number point_value = (Number) ((*p->point - *p->imin) * (1. / (*p->imax -
							     *p->imin)));
	*p->r = point_value * (*p->val2 - *p->val1) + *p->val1;
}

void
nterpol_init(INTERPOL * p)
{
	p->point_factor = 1.0f / (*p->imax - *p->imin);
}

void
knterpol(INTERPOL * p)
{
	Number point_value = (*p->point - *p->imin) * p->point_factor;
	*p->r = point_value * (*p->val2 - *p->val1) + *p->val1;
}

void
anterpol(INTERPOL * p)
{

	Number point_value = (*p->point - *p->imin) * p->point_factor;
	Number *out = p->r, *val1 = p->val1, *val2 = p->val2;
	int16 loopcount = ksmps;
	do {
		*out++ = point_value * (*val2++ - *val1) + *val1++;
	} while (--loopcount);


}

Opcode opcodes[] =
{
	WRAP_OPCODE_LIST,
	{ NULL }
};
