#ifndef __physmod_vibraphn_h__
#define __physmod_vibraphn_h__

/*******************************************/
/*  Vibraphone SubClass of Modal4          */
/*  Module, by Perry R. Cook, 1995-96  */ 
/*                                         */
/*   Controls:    stickHardness 	   */
/*                strikePosition           */
/*		  vibFreq                  */
/*		  vibAmt                   */
/*******************************************/

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

OpcodeArgument(VIBRAPHN)
    Number	*ar;                  /* Output */
    Number	*amplitude, *frequency;
    Number	*hardness, *spos, *ifn;
    Number	*vibFreq, *vibAmt, *ivfn, *dettack;

    Modal4	m4;
    Number	strikePosition;
    Number	stickHardness;
    int32		kloop;
};

extern void vibraphnset (VIBRAPHN *);
extern void vibraphn    (VIBRAPHN *);
extern void agogobelset (VIBRAPHN *);
extern void agogobel    (VIBRAPHN *);

#define VIBRAPHN_OPCODE_LIST \
{"vibes", S(VIBRAPHN), InitTime|AudioTime, "a", "kkiiikkii", \
	 F(vibraphnset), NULL, F(vibraphn), 0, "physutil" }, \
{"gogobel", S(VIBRAPHN), InitTime|AudioTime, "a", "kkiiikki", \
	 F(agogobelset), NULL, F(agogobel), 0, "physutil" }

#endif __physmod_vibraphn_h__
