/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: trigwait.cc,v 1.1 1999/11/01 04:25:04 pbd Exp $
*/

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/dsp.h>
#include <quasimodo/process.h>
#include <quasimodo/trigger.h>

#include "trigwait.h"

static void
_trigwait (DspProcess *p, Number *ptr, Number val, RelationalCondition cond)

{
	Trigger *t;

	t = dsp->get_trigger (ptr, val, cond);
	t->add (p);
	p->suspend ();
}

void
trigwait_init (TRIGGER_DELTA *p)

{
	p->lastval = *p->ptr;
}

void
trigwait (TRIGGER_DELTA *p)

{
	Number x;

	/* can't call Trigger::satisfied(), because it assumes that
	   we know there has been a change.
	*/
	
	if ((x = *p->ptr) == p->lastval) {
		_trigwait (p->PROCESS, p->ptr, p->lastval, Changed);
	}

	p->lastval = x;

}

#define TRIGWAIT(suffix,cond) \
      void \
      trigwait_ ## suffix (TRIGGER *p) \
      { \
		if (Trigger::satisfied (p->ptr, *p->val, cond)) { \
                       return; \
                } \
		_trigwait (p->PROCESS, p->ptr, *p->val, cond);\
      }

TRIGWAIT(lt,LessThan)
TRIGWAIT(lteq,LessThanOrEqual)
TRIGWAIT(gt,GreaterThan)
TRIGWAIT(gteq,GreaterThanOrEqual)
TRIGWAIT(eq,Equal)
TRIGWAIT(neq,NotEqual)

Opcode opcodes[] = {
	TRIGWAIT_OPCODE_LIST,
	{ NULL }
};
