/*
    Copyright (C) 1999 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: soundio.h,v 1.5 1999/12/15 19:41:40 pbd Exp $
*/

OpcodeArgument(IN)
	Number	*ar;
};

OpcodeArgument(INS)
	Number	*ar1, *ar2;
};

OpcodeArgument(INQ)
	Number	*ar1, *ar2, *ar3, *ar4;
};

OpcodeArgument(INH)
	Number	*ar1, *ar2, *ar3, *ar4, *ar5, *ar6;
};

OpcodeArgument(INO)
	Number	*ar1, *ar2, *ar3, *ar4, *ar5, *ar6, *ar7, *ar8;
};

OpcodeArgument(OUT)
	Number	*asig;
};

OpcodeArgument(OUTS)
	Number	*asig1, *asig2;
};

OpcodeArgument(OUTQ)
	Number	*asig1, *asig2, *asig3, *asig4;
};

OpcodeArgument(OUTH)
	Number	*asig1, *asig2, *asig3, *asig4, *asig5, *asig6;
};

OpcodeArgument(OUTO)
	Number	*asig1, *asig2, *asig3, *asig4, *asig5, *asig6, *asig7, *asig8;
};

extern void in (IN *p);
extern void ins (INS *p);
extern void inq (INQ *p);
extern void inh (INH *p);
extern void ino (INO *p);
extern void out (OUT *p);
extern void outs (OUTS *p);
extern void outq (OUTQ *p);
extern void outs1 (OUT *p);
extern void outs2 (OUT *p);
extern void outs12 (OUT *p);
extern void outq1 (OUT *p);
extern void outq2 (OUT *p);
extern void outq3 (OUT *p);
extern void outq4 (OUT *p);
extern void outh (OUTH *p);
extern void outo (OUTO *p);

#define SOUNDIO_OPCODE_LIST \
{"in", S(IN), AudioTime, "a", "", \
	 NULL, NULL, F(in), OP_REQUIRES_INPUT|OP_REQUIRES_MONO}, \
{"ins", S(INS), AudioTime, "aa", "", \
	 NULL, NULL, F(ins), OP_REQUIRES_INPUT|OP_REQUIRES_STEREO }, \
{"inq", S(INQ), AudioTime, "aaaa", "", \
	 NULL, NULL, F(inq), OP_REQUIRES_INPUT|OP_REQUIRES_QUAD }, \
{"inh", S(INQ), AudioTime, "aaaaaa", "", \
	 NULL, NULL, F(inh), OP_REQUIRES_INPUT|OP_REQUIRES_HEX }, \
{"ino", S(INQ), AudioTime, "aaaaaaaa", "", \
	 NULL, NULL, F(ino), OP_REQUIRES_INPUT|OP_REQUIRES_OCT}, \
{"out", S(OUT), AudioTime, "", "a", NULL, NULL, F(out), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_MONO}, \
{"outs", S(OUTS), AudioTime, "", "aa", NULL, NULL, F(outs), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_STEREO }, \
{"outq", S(OUTQ), AudioTime, "", "aaaa", NULL, NULL, F(outq), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_QUAD }, \
{"outh", S(OUTQ), AudioTime, "", "aaaaaa", NULL, NULL, F(outh), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_HEX }, \
{"outo", S(OUTQ), AudioTime, "", "aaaaaaaa", NULL, NULL, F(outo), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_OCT }, \
{"outs1", S(OUT), AudioTime, "", "a", NULL, NULL, F(outs1), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_STEREO }, \
{"outs2", S(OUT), AudioTime, "", "a", NULL, NULL, F(outs2), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_STEREO }, \
{"outq1", S(OUT), AudioTime, "", "a", NULL, NULL, F(outq1), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_QUAD }, \
{"outq2", S(OUT), AudioTime, "", "a", NULL, NULL, F(outq2), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_QUAD }, \
{"outq3", S(OUT), AudioTime, "", "a", NULL, NULL, F(outq3), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_QUAD }, \
{"outq4", S(OUT), AudioTime, "", "a", NULL, NULL, F(outq4), \
	 OP_REQUIRES_OUTPUT|OP_REQUIRES_QUAD },


