/*
    Copyright (C) 1999 Stephane Conversy
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: rtline.h,v 1.1 1999/11/18 10:53:41 stef Exp $
*/

#ifndef __qm_rtline_h__
#define __qm_rtline_h__

#include <quasimodo/opcode_defs.h>

/*
line generator: generates values at k-rate wich are linear interpolated
values between the last value generated and 'target' during 'duration' seconds.
When the target value is reached, it produces this value continuously.
Each time 'duration' is touched, it begins the cycle (ie, first set the 'target' value
then the 'duration').
'start' is the first value.

*/


OpcodeArgument(RTLINE)
        Number   *kout;
        Number   *start, *target, *duration;
		Number	a,inc, lastdur, count;
};


extern void rtlineset (RTLINE *p);
extern void rtlinek  (RTLINE *p);
//extern void rtlinea  (RTLINE *p);

#define RTLINE_OPCODE_LIST \
{\
	"rtline", S(RTLINE), InitTime|EventTime|AudioTime, "k", "iXX", \
	  F(rtlineset), F(rtlinek), NULL\
}

#endif //  __qm_rtline_h__
