#ifndef __qm_resonz_h__
#define __qm_resonz_h__

/* resonrz.h
 *
 * Copyright 1999, by Sean M. Costello
 *
 * resonr and resonz are implementations of second-order 
 * bandpass resonators, with added zeroes in the transfer function.
 * The algorithms are based upon the work of Julius O. Smith and
 * John Stautner at Stanford, and Ken Steiglitz at Princeton.
 *
 */

#include <quasimodo/opcode_defs.h>

OpcodeArgument(RESONZ)
        Number *out, *in, *kcf, *kbw, *iscl, *istor;
        Number xnm1, xnm2, ynm1, ynm2;
        int32 scaletype, aratemod;
};

void resonzset (RESONZ *);
void resonr    (RESONZ *);
void resonz    (RESONZ *);

#define RESONZ_OPCODE_LIST \
{ "resonr", S(RESONZ), InitTime|AudioTime, "a", "akkoo", \
      F(resonzset), NULL, F(resonr) }, \
{ "resonz", S(RESONZ), InitTime|AudioTime, "a", "akkoo", \
      F(resonzset), NULL, F(resonz) }


#endif  __qm_resonz_h__
