/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: reset.h,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#ifndef __op_reset_h__
#define __op_reset_h__

#include <quasimodo/opcode_defs.h>

OpcodeArgument(RESET)
    DspInstruction h;
    Number *r, *v;
    qm_time_t *last_reset;
};

extern void reset_init   (RESET *);
extern void reset_scalar (RESET *);
extern void reset_vector (RESET *);

#define RESET_OPCODES_LIST \
{"reset",   S(RESET), InitTime|EventTime, "X", "X", \
	 F(reset_init), F(reset_scalar) }, \
{"reset_a", S(RESET), InitTime|EventTime, "a", "x", \
	 F(reset_init), NULL, F(reset_vector) }

#endif __op_reset_h__
