/*
    This is based on stuff by Robin Whittle and Gabriel Maldonado

    Copyright (C) 1998-99 Paul Barton-Davis
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: printk.h,v 1.3 1999/12/18 18:24:27 pbd Exp $
*/

#ifndef __qm_printk_h__
#define __qm_printk_h__

#include <quasimodo/opcode_defs.h>

#define TEXTMSG_MAXARGS 10
				
OpcodeArgument(TEXTMSG)
	Number *args[TEXTMSG_MAXARGS];
};

OpcodeArgument(PRINTK)
	/* input args */
	Number 	*ptime;		/* seconds to leave between each print*/
	Number	*val;		/* Value to print */
	Number	*pspace;	/* Spaces to insert before printing */
        Number	lasttime;	/* Last printed */
	/* closure data */
        Number  ctime;          
	size_t	space;
};

OpcodeArgument(PRINTKS)
	/* input args */
	Number	*ptime;		  /* seconds to leave between each print */
	Number  *fmt;             /* printf(3)-style format string */
	Number	*args[TEXTMSG_MAXARGS];
	/* closure data */
	Number	lasttime;
	Number  ctime;
	const char *format;
};

OpcodeArgument(PRINTA)
	/* input args */
	Number	*ptime;		  /* seconds to leave between each print */
	Number	*name;            /* name of audio value (printed) */
	Number  *val;             /* audio value to print */
	/* closure data */
	Number	lasttime;
	Number  ctime;
	const char *val_name;
};

OpcodeArgument(PRINTKD) 
        /* input args */
	Number *pname; 
	Number *val;
        /* closure data */
	Number oldvalue; 
	const char *name; 
};

extern void printmsg (TEXTMSG *p);
extern void printkset (PRINTK *p);
extern void printk (PRINTK *p);
extern void printksset (PRINTKS *p);
extern void printks (PRINTKS *p);
extern void printas (PRINTA *p);
extern void printkdset (PRINTKD *p);
extern void printkd (PRINTKD *p);

#define PRINTK_OPCODE_LIST \
{"printmsg", S(TEXTMSG), EventTime, "", "VVVVVVVVVV", \
	 NULL, F(printmsg)}, \
{"printk", S(PRINTK), InitTime|EventTime, "", "xxo", \
	 F(printkset), F(printk), NULL}, \
{"printks", S(PRINTKS), InitTime|EventTime, "", "xSVVVVVVVVVV", \
	 F(printksset), F(printks), }, \
{"printa", S(PRINTA), InitTime|EventTime, "", "xSa", \
	 F(printaset), F(printa), NULL, }, \
{"printkd", S(PRINTKD), InitTime|EventTime, "", "Sx", \
	 F(printkdset), F(printkd), NULL }

#endif __qm_printk_h__
