#ifndef __moog1_h__
#define __moog1_h__


/******************************************/
/*  Moog1 Subclass of                     */                   
/*  Sampling Synthesizer Class            */
/*  by Perry R. Cook, 1995-96             */ 
/*                                        */
/*   Controls:    CONTROL1 = filterQ      */
/*                CONTROL2 = filterRate   */
/*		  CONTROL3 = vibFreq      */
/*		  MOD_WHEEL= vibAmt       */
/******************************************/

#include "physutil.h"
#include "fm4op.h"

/*******************************************/
/*  Master Class for Sampling Synthesizer  */
/*  by Perry R. Cook, 1995-96              */ 
/*  This module contains up to 5       */
/*  attack waves, 5 looped waves, and      */
/*  an ADSR envelope.                      */
/*******************************************/

OpcodeArgument(MOOG1)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*filterQ, *filterRate, *vibf, *vibAmt;
    Number	*iatt, *ifn, *ivfn;

    ADSR        adsr; 
    Wave	attk;      /* Not looped */
    Wave        loop;      /* Looped */
    Wave	vibr;      /* Looped */
    OnePole     filter;
    Number	baseFreq;
    Number	attackRatio;
    Number	loopRatio;
    Number	attackGain;
    Number	loopGain;
    Number	oldfilterQ;
    Number	oldfilterRate;
    FormSwep	filters[2];
    TwoZero	twozeroes[2];
};

extern void make_TwoZero (TwoZero *);
extern void TwoZero_setZeroCoeffs (TwoZero *, Number *);
extern Number TwoZero_tick (TwoZero *, Number);

extern void Moog1set (MOOG1 *p);
extern void Moog1 (MOOG1 *p);

#define MOOG1_OPCODE_LIST \
{"moog", S(MOOG1), InitTime|AudioTime, "a", "kkkkkkiii", \
	 F(Moog1set), NULL, F(Moog1), 0, "physutil" }



#endif __moog1_h__

