#ifndef __mandolin_h__
#define __mandolin_h__

/**********************************************************************/  
/*  Commuted Mandolin Subclass of enhanced dual plucked-string model  */
/*  by Perry Cook, 1995-96                                            */
/*   Controls:	bodySize    pluckPosition	loopGain    deTuning  */
/*                                          			      */
/*  Note: Commuted Synthesis, as with many other WaveGuide techniques,*/
/*  is covered by patents, granted, pending, and/or applied-for.  All */
/*  are assigned to the Board of Trustees, Stanford University.       */
/*  For information, contact the Office of Technology Licensing,      */
/*  Stanford U.                                                       */
/**********************************************************************/  

#include <quasimodo/opcode_defs.h>
#include <quasimodo/function_tables.h>
#include "physutil.h"

OpcodeArgument(MANDOL)
    Number	*ar;                  /* Output */
    Number	*amp;
    Number	*frequency;
    Number	*pluckPos;
    Number	*detuning;
    Number	*baseLoopGain;
    Number	*s_rate;
    Number	*ifn;
    Number	*lowestFreq;

    RCPointer<FunctionTable> soundfile;
    float	s_time;
    float	s_lastOutput;
    DLineA	delayLine1;
    DLineA	delayLine2;
    DLineL	combDelay;
    OneZero	filter1;
    OneZero	filter2;
    long	length;
    float	lastFreq;
    float	lastLength;
    long	dampTime;
    int		waveDone;
    int		kloop;
};


extern void mandolinset (MANDOL *p);
extern void mandolin (MANDOL *p);

#define MANDOLIN_OPCODE_LIST \
{"mandol", S(MANDOL), InitTime|AudioTime, "a", "kkkkkkio", \
	 F(mandolinset), NULL, F(mandolin), 0, "physutil" }

#endif __mandolin_h__

