/*
    This file is derived from source code distributed as part of
    Csound, a program licensed by MIT. It is Copyright (C) any of
    the named parties in the MIT license and/or original Csound
    source code. Every attempt has been made to leave copyright
    holder's names and other identifying information in place.

    It is subject to the same licensing restrictions as Csound. A copy
    of the license is part of the distribution that this file was
    a part of, and is called Csound-Copyright. Because of the
    restrictions in that license, it is necessary to note that:

    This work was carried out to further education and research in the
    field of computer music. Although the program it is intended to be
    used with may be used for any purpose as a compiled binary, the
    source code can only be used for other purposes related to 
    education and research.

    $Id: lpc.h,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#ifndef __cs_lpc_h__
#define __cs_lpc_h__

#include <quasimodo/opcode_defs.h>

#define	LP_MAGIC    999
#define LP_MAGIC2   2399	   /* pole file type */
#define LPBUFSIZ    4096           /* in lpanal */
#define MAXWINDIN   1000           /* for 10ms hops at 50 KC */
#define	MAXPOLES    50
#define NDATA	    4	           /* number of data values stored with frame */

OpcodeArgument(LPHEADER)
	Number	framrate, srate, duration;
	char	text[4];
};

OpcodeArgument(LPREAD)
	Number	*krmr, *krmo, *kerr, *kcps, *ktimpt, *ifilno, *inpoles, *ifrmrate;
	int32	headlongs, npoles, nvals, lastfram16, lastmsg;
	Number	kcoefs[MAXPOLES*2], framrat16;
	int16	storePoles ;
	MEMFIL	*mfp;
};

OpcodeArgument(LPRESON)
	Number	*ar, *asig;
	Number	circbuf[MAXPOLES<<1], *circjp, *jp2lim;
	LPREAD	*lpread;
};

OpcodeArgument(LPFRESON)
	Number	*ar, *asig, *kfrqratio;
	Number	past[MAXPOLES], prvratio, d, prvout;
	LPREAD	*lpread;
};


OpcodeArgument(LPSLOT)
	Number   *islotnum ; /* Assume sizeof(int)== sizeof(Number) */
};

OpcodeArgument(LPINTERPOL)
	Number   *islot1 ; 
	Number   *islot2 ; /* Assume sizeof(pointer)== sizeof(Number) */
	Number   *kmix  ;
	Number	*fpad[5]; /* Pad for kcoef correctly put (Mighty dangerous) */
	int32    lpad,npoles ;
	LPREAD  *lp1,*lp2 ;
	int32	lastmsg;
	Number	kcoefs[MAXPOLES*2], framrat16;
	int16	storePoles ;
};


#if DO_LP_STUFF
{ "lpread", S(LPREAD),	InitTime|EventTime,	"kkkk",	"kSoo",	lprdset,lpread		}, \
{ "lpreson",S(LPRESON),	InitTime|AudioTime,	"a",	"a",	lprsnset,NULL,	lpreson	}, \
{ "lpfreson",S(LPFRESON),InitTime|AudioTime,	"a",	"ak",	lpfrsnset,NULL,	lpfreson}, \
{ "lpslot"  ,  S(LPSLOT),  InitTime,   "",     "i",    lpslotset, NULL, NULL   }, \
{ "lpinterp", S(LPINTERPOL), InitTime|EventTime, "",     "iik",  lpitpset, lpinterpol, NULL}, \
#endif

#endif __cs_lpc_h__
