/*
    Permission granted for GPL release by Gabriel Maldonado, April 1999

    Copyright (C) 1998-99 Gabriel Maldonado
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: lowpassr.h,v 1.1 1999/11/01 04:25:03 pbd Exp $
*/

#ifndef __lowpassr_h__
#define __lowpassr_h__

#include <quasimodo/opcode_defs.h>

OpcodeArgument(LOWPR)
	Number	*ar, *asig, *kfco, *kres, *istor;
	Number	ynm1, ynm2;  
};


OpcodeArgument(LOWPRX)
	Number	*ar, *asig, *kfco, *kres, *ord, *istor;
	Number	ynm1[10], ynm2[10] ;   
	int16	loop;
};

OpcodeArgument(LOWPR_SEP)
	Number	*ar, *asig, *kfco, *kres, *ord, *sep;
	Number	ynm1[10], ynm2[10], cut[10];  
	int16	loop;
};

extern void lowpr_set (LOWPR *p);
extern void lowpr (LOWPR *p);
extern void lowpr_setx (LOWPRX *p);
extern void lowprx (LOWPRX *p);
extern void lowpr_w_sep_set (LOWPR_SEP *p);
extern void lowpr_w_sep (LOWPR_SEP *p);

#define LOWPASSR_OPCODE_LIST \
{"lowres", S(LOWPR), InitTime|AudioTime, "a", "akko", \
	 F(lowpr_set), NULL, F(lowpr)}, \
{"lowresx", S(LOWPRX), InitTime|AudioTime, "a", "akkoo", \
	 F(lowpr_setx), NULL, F(lowprx)}, \
{"vlowres", S(LOWPR_SEP), InitTime|AudioTime, "a", "akkik", F(lowpr_w_sep_set), NULL, \
	 F(lowpr_w_sep)}, \
{"lpres", S(LOWPR), InitTime|AudioTime, "a", "akk", \
	 F(lowpr_set), NULL, F(lowpr)}, \
{"lpresx", S(LOWPRX), InitTime|AudioTime, "a", "akko", \
	 F(lowpr_setx), NULL, F(lowprx)}



#endif __lowpassr_h__

