/*
    Permission granted for GPL release by Gabriel Maldonado, April 1999

    Copyright (C) 1998-99 Gabriel Maldonado
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: lowpassr.cc,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/


#include <math.h>

#include <quasimodo/qm.h>
#include <quasimodo/opcode.h>
#include <quasimodo/opcode_enums.h>

#include "lowpassr.h"

void
lowpr_set(LOWPR * p)
{
	if (*p->istor == 0.0f)
		p->ynm1 = p->ynm2 = 0.0f;
}

void
lowpr(LOWPR * p)
{
	Number b, k;
	Number *ar, *asig, yn, ynm1, ynm2;
	Number kfco = *p->kfco;
	Number coef1, coef2;
	int32 nsmps = ksmps;

	b = 10.0f / (*p->kres * (Number) sqrt((double) kfco)) - 1.0f;
	k = 1000.0f / kfco;
	coef1 = (b + 2.0f * k);
	coef2 = 1.0f / (1.0f + b + k);

	ar = p->ar;
	asig = p->asig;
	ynm1 = p->ynm1;
	ynm2 = p->ynm2;

	do {
		*ar++ = yn = (coef1 * ynm1 - k * ynm2 + *asig++) * coef2;
		ynm2 = ynm1;
		ynm1 = yn;
	} while (--nsmps);
	p->ynm1 = ynm1;
	p->ynm2 = ynm2;		/* And save */

}

void
lowpr_setx(LOWPRX * p)
{
	int32 j;
	if ((p->loop = (int32) (*p->ord + 0.5f)) < 1)
		p->loop = 4;	/*default value */
	else if (p->loop > 10)
		p->error ("illegal order num. (min 1, max 10)");

	if (*p->istor != 0)
		for (j = 0; j < p->loop; j++)
			p->ynm1[j] = p->ynm2[j] = 0.0f;

}

void
lowprx(LOWPRX * p)
{
	Number b, k;
	Number *ar, *asig, yn, *ynm1, *ynm2;
	Number coef1, coef2;
	Number kfco = *p->kfco;
	int32 nsmps, j;

	b = (Number) (10.0f / (*p->kres * (Number) sqrt((double) kfco)) - 1.0f);
	k = 1000.0f / kfco;
	coef1 = (b + 2.0f * k);
	coef2 = 1.0f / (1.0f + b + k);

	ynm1 = p->ynm1;
	ynm2 = p->ynm2;
	asig = p->asig;

	for (j = 0; j < p->loop; j++) {
		nsmps = ksmps;
		ar = p->ar;

		do {
			*ar++ = yn = (coef1 * *ynm1 - k * *ynm2 + *asig++) *
			    coef2;
			*ynm2 = *ynm1;
			*ynm1 = yn;
		} while (--nsmps);
		ynm1++;
		ynm2++;
		asig = p->ar;
	}
}


void
lowpr_w_sep_set(LOWPR_SEP * p)
{
	int32 j;
	if ((p->loop = (int32) (*p->ord + 0.5)) < 1)
		p->loop = 4;	/*default value */
	else if (p->loop > 10)
		p->error ("illegal order num. (min 1, max 10)");

	for (j = 0; j < p->loop; j++)
		p->ynm1[j] = p->ynm2[j] = 0.0f;
}

void
lowpr_w_sep(LOWPR_SEP * p)
{
	Number b, k;
	Number *ar, *asig, yn, *ynm1, *ynm2;
	Number coef1, coef2;
	Number kfcobase = *p->kfco;
	Number sep = (*p->sep / p->loop);
	int32 nsmps, j;

	Number kres = *p->kres;
	Number kfco;
	ynm1 = p->ynm1;
	ynm2 = p->ynm2;
	asig = p->asig;

	for (j = 0; j < p->loop; j++) {
		/*
		   linfco=log((double) kfco)*ONEtoLOG2  ;
		   linfco = linfco + (sep / p->loop)*j;
		   kfco = (Number) pow(2.,linfco);
		 */
		kfco = kfcobase * (1.0f + (sep * j));

		b = 10.0f / (kres * (Number) sqrt((double) kfco)) - 1.0f;
		k = 1000.0f / kfco;
		coef1 = (b + 2.0f * k);
		coef2 = 1.0f / (1.0f + b + k);

		nsmps = ksmps;
		ar = p->ar;
		do {		/* This can be speeded up avoiding
				   indirection */
			*ar++ = yn = (coef1 * *ynm1 - k * *ynm2 + *asig++) *
			    coef2;
			*ynm2 = *ynm1;
			*ynm1 = yn;
		} while (--nsmps);
		ynm1++;
		ynm2++;
		asig = p->ar;
	}
}

Opcode opcodes[] =
{
	LOWPASSR_OPCODE_LIST,
	{NULL}
};

