/*
    Copyright (C) 1998-99 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: internal_opcodes.h,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/

#ifndef __qm_internal_opcodes_h__
#define __qm_internal_opcodes_h__

#include <quasimodo/opcode_defs.h>

OpcodeArgument(PATCHPTR)
    Number *result;
    Number *ptr;
};

OpcodeArgument(VOICELIMIT)
    Number *n;
};

extern void patched (PATCHPTR *);
extern void voicelimit (VOICELIMIT *);
extern void polyphonic (BASIC_OP_ARG *);
extern void midibind (BASIC_OP_ARG *);

#define INTERNAL_OPCODE_LIST \
{"patched", S(PATCHPTR), InitTime|EventTime, "X", "x", \
	 F(patched), F(patched), NULL }, \
{"voicelimit", S(VOICELIMIT), InitTime, "", "x", \
	 F(voicelimit), NULL, NULL }, \
{"polyphonic", S(BASIC_OP_ARG), InitTime, "", "", \
	 F(polyphonic), NULL, NULL }, \
{"midibind", S(BASIC_OP_ARG), InitTime, "", "", \
	 F(midibind), NULL, NULL, OP_BINDS_MIDI }

#endif  __qm_internal_opcodes_h__
