#ifndef __qm_hilbert_h__
#define __qm_hilbert_h__

/* hilbert.h
 *
 * Copyright 1999, by Sean M. Costello
 *
 * hilbert is an implementation of an IIR Hilbert transformer.
 * The structure is based on two 6th-order allpass filters in 
 * parallel, with a constant phase difference of 90 degrees
 * (+- some small amount of error) between the two outputs.
 * Allpass coefficients are calculated at i-time.
 */

#include <quasimodo/opcode_defs.h>

OpcodeArgument(HILBERT)
        Number *out1, *out2, *in;
        Number xnm1[12], ynm1[12], coef[12];
};

void hilbertset (HILBERT *);
void hilbert    (HILBERT *);

#define HILBERT_OPCODE_LIST \
{ "hilbert", S(HILBERT), InitTime|AudioTime, "aa", "a", \
     F(hilbertset), NULL, F(hilbert) }

#endif __qm_hilbert_h__
