/******************************************/
/*  WaveGuide Flute ala Karjalainen,      */
/*  Smith, Waryznyk, etc.                 */
/*  with polynomial Jet ala Cook          */
/*  by Perry Cook, 1995-96                */
/*  Recoded for Csound by John ffitch     */
/*  November 1997                         */
/*                                        */
/*  This is a waveguide model, and thus   */
/*  relates to various Stanford Univ.     */
/*  and possibly Yamaha and other patents.*/
/*                                        */
/******************************************/

#ifndef __qm_flute_h__
#define __qm_flute_h__

#include <quasimodo/opcode_defs.h>
#include "physutil.h"

/**********************************************/
/* Jet Table Object by Perry R. Cook, 1995-96 */
/* Consult Fletcher and Rossing, Karjalainen, */
/*       Cook, more, for information.         */
/* This, as with many other of my "tables",   */
/* is not a table, but is computed by poly-   */
/* nomial calculation.                        */
/**********************************************/

Number JetTabl_lookup(Number);

OpcodeArgument(FLUTE)
    Number	*ar;                  /* Output */
    Number	*amp, *frequency;
    Number	*jetRatio, *attack, *dettack, *noiseGain, *vibFreq;
    Number	*vibAmt, *ifn, *lowestFreq; 
    Number	*jetRefl;       /* Optional 0.5 */
    Number	*endRefl;       /* Optional 0.5 */

    RCPointer<FunctionTable>	vibr;
    Number	v_rate;         /* Parameters for vibrato */
    Number	v_time;
    DLineL	jetDelay;
    DLineL	boreDelay;
    OnePole	filter;
    DCBlock	dcBlock;
    Noise	noise;
    ADSR	adsr;
    Number	lastFreq;
    Number	lastJet;
    Number	maxPress;
    Number	vibrGain;
    Number	outputGain;
    Number	kloop;
    Number       lastamp;
};

extern void fluteset(FLUTE*);
extern void flute(FLUTE*);

#define FLUTE_OPCODE_LIST \
{"wgflute", S(FLUTE), InitTime|AudioTime, "a", "kkkiikkkiovv", \
	 F(fluteset), NULL, F(flute), 0, "physutil" }

#endif __qm_flute_h__
