/*
    Copyright (C) 1998 Gabriel Maldonado 

    GPL release granted to Paul Barton-Davis via email, April 1999.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    aint32 with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: flanger.h,v 1.1 1999/11/01 04:25:02 pbd Exp $
*/

#ifndef __flanger_h__
#define __flanger_h__

#include <quasimodo/opcode_defs.h>
#include <quasimodo/dynamic_memory.h>

OpcodeArgument(FLANGER)
	Number	*ar, *asig, *xdel, *kfeedback, *maxd;
	Number	yt1; /* filter instance variables */
	AUXCH	aux;  /* delay instance variables */
	int32	left;
	uint32 maxdelay;
	Number	fmaxd;
};

OpcodeArgument(WGUIDE1)
	Number *ar, *asig, *xdel, *filt_khp, *kfeedback;
	Number c1, c2, yt1, prvhp; /* filter instance variables */
	AUXCH	aux;  /* delay instance variables */
	int32	left;
	uint32 maxd; /* max delay samples */
};

OpcodeArgument(WGUIDE2)
	Number *ar, *asig, *xdel1, *xdel2, *filt_khp1;
	Number *filt_khp2, *kfeedback1, *kfeedback2;
	Number c1_1, c2_1, yt1_1, prvhp1; /* filter1 instance variables */
	Number c1_2, c2_2, yt1_2, prvhp2; /* filter1 instance variables */
	AUXCH	aux1;  /* delay1 instance variables */
	int32	left1;
	AUXCH	aux2;  /* delay1 instance variables */
	int32	left2;
	Number	old_out;
	uint32 maxd; /* max delay samples */
};

extern void flanger_set (FLANGER *p);
extern void flanger (FLANGER *p);
extern void wguide1set (WGUIDE1 *p);
extern void wguide1 (WGUIDE1 *p);
extern void wguide2set (WGUIDE2 *p);
extern void wguide2 (WGUIDE2 *p);


#define FLANGER_OPCODE_LIST \
  {"flanger", S(FLANGER), InitTime|EventTime, "a", "aakv", \
	   F(flanger_set), NULL, F(flanger)}


#endif __flanger_h__

