/*
    Copyright (C) 1999 Paul Barton-Davis 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Id: fileops.h,v 1.5 1999/12/06 04:12:54 pbd Exp $
*/

#include <stdio.h>
#include <quasimodo/opcode_defs.h>

OpcodeArgument(FILEOPEN)
	/* output args */
	Number *file_index;
	/* input args */
	Number *path;
	Number *mode;
};

OpcodeArgument(FILETMP)
	/* output args */
	Number *file_index;
	/* no input args */
};

OpcodeArgument(FILECLOSE)
	/* no output args */
	/* input args */
	Number *file_index;
};

OpcodeArgument(FILEIO)
	/* no output args */
	/* input */
	Number *file_index;
	Number *data;
};

OpcodeArgument(FILESEEK)
	/* no output args */
	/* input args */
	Number *file_index;
	Number *position;
	Number *whence; /* 0 = beginning, 1 = relative, 2 = end */
};

OpcodeArgument(FILEMISC)
	/* output args */
	Number *result;
	/* input args */
	Number *file_index;
};

OpcodeArgument(FILETRUNCATE)
	/* no output */
	/* input args */
	Number *file_index;
	Number *new_size;
};

extern void fileread(FILEIO*);
extern void filewrite(FILEIO*);

#define FILEOPS_OPCODE_LIST \
{"fopen", S(FILEOPEN),InitTime,"x", "SS", \
         F(fileopen),NULL,NULL }, \
{"tmpfile", S(FILETMP),InitTime,"x", "", \
         F(filetmp),NULL,NULL }, \
{"fclose", S(FILECLOSE),EventTime, "", "x", \
         NULL,F(filewrite),NULL }, \
{"fwrite", S(FILEIO),EventTime,"", "xx", \
         NULL,F(filewrite),F(filewrite) }, \
{"fread", S(FILEIO),EventTime, "", "xx", \
         NULL,F(fileread),F(fileread) }, \
{"fseek", S(FILESEEK),EventTime,"", "xxx", \
         NULL,F(fileseek),NULL }, \
{"ftell", S(FILEMISC),EventTime,"x", "x", \
         NULL,F(filetell),NULL }, \
{"ferror", S(FILEMISC),EventTime,"x", "x", \
         NULL,F(fileerror),NULL }, \
{"feof", S(FILEMISC),EventTime,"x", "x", \
         NULL,F(fileeof),NULL }, \
{"ftruncate", S(FILETRUNCATE),EventTime, "", "xx", \
         NULL,F(filetruncate),NULL }

